<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GenerateQuotation
     * Meta information extracted from the WSDL
     * - documentation: This method accepts a valid username, API Key in addition to other fields required to create a quotation. It creates and returns the details of the new quotation in the response, including options for different Access Providers, were
     * applicable. Note that, this quotation has only been created but not ordered (as indicative of the nil DateOrdered property) to the pricing team. To order a quote, please contact the pricing team.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateQuotation $parameters
     * @return \StructType\GenerateQuotationResponse|bool
     */
    public function GenerateQuotation(\StructType\GenerateQuotation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateQuotation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenerateQuotationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
