<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloudConnectRequest StructType
 * @subpackage Structs
 */
class CloudConnectRequest extends AbstractStructBase
{
    /**
     * The Bandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Bandwidth;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provider;
    /**
     * Constructor method for CloudConnectRequest
     * @uses CloudConnectRequest::setBandwidth()
     * @uses CloudConnectRequest::setProvider()
     * @param int $bandwidth
     * @param string $provider
     */
    public function __construct($bandwidth = null, $provider = null)
    {
        $this
            ->setBandwidth($bandwidth)
            ->setProvider($provider);
    }
    /**
     * Get Bandwidth value
     * @return int
     */
    public function getBandwidth()
    {
        return $this->Bandwidth;
    }
    /**
     * Set Bandwidth value
     * @param int $bandwidth
     * @return \StructType\CloudConnectRequest
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: int
        if (!is_null($bandwidth) && !(is_int($bandwidth) || ctype_digit($bandwidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->Bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \StructType\CloudConnectRequest
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
}
