<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateQuotation StructType
 * @subpackage Structs
 */
class GenerateQuotation extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApiKey;
    /**
     * The circuit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CircuitDetails
     */
    public $circuit;
    /**
     * Constructor method for GenerateQuotation
     * @uses GenerateQuotation::setUsername()
     * @uses GenerateQuotation::setApiKey()
     * @uses GenerateQuotation::setCircuit()
     * @param string $username
     * @param string $apiKey
     * @param \StructType\CircuitDetails $circuit
     */
    public function __construct($username = null, $apiKey = null, \StructType\CircuitDetails $circuit = null)
    {
        $this
            ->setUsername($username)
            ->setApiKey($apiKey)
            ->setCircuit($circuit);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GenerateQuotation
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get ApiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->ApiKey;
    }
    /**
     * Set ApiKey value
     * @param string $apiKey
     * @return \StructType\GenerateQuotation
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->ApiKey = $apiKey;
        return $this;
    }
    /**
     * Get circuit value
     * @return \StructType\CircuitDetails|null
     */
    public function getCircuit()
    {
        return $this->circuit;
    }
    /**
     * Set circuit value
     * @param \StructType\CircuitDetails $circuit
     * @return \StructType\GenerateQuotation
     */
    public function setCircuit(\StructType\CircuitDetails $circuit = null)
    {
        $this->circuit = $circuit;
        return $this;
    }
}
