<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CircuitDetails StructType
 * @subpackage Structs
 */
class CircuitDetails extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductType;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The AEndNNIId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndNNIId;
    /**
     * The ShadowVlanNNIId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ShadowVlanNNIId;
    /**
     * The AEndFloor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndFloor;
    /**
     * The BEndFloor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BEndFloor;
    /**
     * The AEndPoPId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndPoPId;
    /**
     * The BEndPoPId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BEndPoPId;
    /**
     * The CRMReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CRMReference;
    /**
     * The AEndPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndPostcode;
    /**
     * The BEndPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndPostcode;
    /**
     * The PortAndBandwidths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPortAndBandwidth
     */
    public $PortAndBandwidths;
    /**
     * The TermLengthInMonths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $TermLengthInMonths;
    /**
     * The AEndLocationIdentifiers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLocationIdentifier
     */
    public $AEndLocationIdentifiers;
    /**
     * The BEndLocationIdentifiers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLocationIdentifier
     */
    public $BEndLocationIdentifiers;
    /**
     * The AEndExcludeNeosOnnet
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AEndExcludeNeosOnnet;
    /**
     * The BEndExcludeNeosOnnet
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $BEndExcludeNeosOnnet;
    /**
     * The IsDiverse
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDiverse;
    /**
     * The IsManagedDIA
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsManagedDIA;
    /**
     * The InstallAmortisation
     * Meta information extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InstallAmortisation;
    /**
     * The ChosenAccessTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ChosenAccessTypes;
    /**
     * The AdditionalServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalServices;
    /**
     * The CloudConnectOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCloudConnectRequest
     */
    public $CloudConnectOptions;
    /**
     * Constructor method for CircuitDetails
     * @uses CircuitDetails::setProductType()
     * @uses CircuitDetails::setCustomerId()
     * @uses CircuitDetails::setAEndNNIId()
     * @uses CircuitDetails::setShadowVlanNNIId()
     * @uses CircuitDetails::setAEndFloor()
     * @uses CircuitDetails::setBEndFloor()
     * @uses CircuitDetails::setAEndPoPId()
     * @uses CircuitDetails::setBEndPoPId()
     * @uses CircuitDetails::setCRMReference()
     * @uses CircuitDetails::setAEndPostcode()
     * @uses CircuitDetails::setBEndPostcode()
     * @uses CircuitDetails::setPortAndBandwidths()
     * @uses CircuitDetails::setTermLengthInMonths()
     * @uses CircuitDetails::setAEndLocationIdentifiers()
     * @uses CircuitDetails::setBEndLocationIdentifiers()
     * @uses CircuitDetails::setAEndExcludeNeosOnnet()
     * @uses CircuitDetails::setBEndExcludeNeosOnnet()
     * @uses CircuitDetails::setIsDiverse()
     * @uses CircuitDetails::setIsManagedDIA()
     * @uses CircuitDetails::setInstallAmortisation()
     * @uses CircuitDetails::setChosenAccessTypes()
     * @uses CircuitDetails::setAdditionalServices()
     * @uses CircuitDetails::setCloudConnectOptions()
     * @param string $productType
     * @param int $customerId
     * @param int $aEndNNIId
     * @param int $shadowVlanNNIId
     * @param int $aEndFloor
     * @param int $bEndFloor
     * @param int $aEndPoPId
     * @param int $bEndPoPId
     * @param string $cRMReference
     * @param string $aEndPostcode
     * @param string $bEndPostcode
     * @param \ArrayType\ArrayOfPortAndBandwidth $portAndBandwidths
     * @param \ArrayType\ArrayOfInt $termLengthInMonths
     * @param \ArrayType\ArrayOfLocationIdentifier $aEndLocationIdentifiers
     * @param \ArrayType\ArrayOfLocationIdentifier $bEndLocationIdentifiers
     * @param bool $aEndExcludeNeosOnnet
     * @param bool $bEndExcludeNeosOnnet
     * @param bool $isDiverse
     * @param bool $isManagedDIA
     * @param bool $installAmortisation
     * @param \ArrayType\ArrayOfString $chosenAccessTypes
     * @param \ArrayType\ArrayOfString $additionalServices
     * @param \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions
     */
    public function __construct($productType = null, $customerId = null, $aEndNNIId = null, $shadowVlanNNIId = null, $aEndFloor = null, $bEndFloor = null, $aEndPoPId = null, $bEndPoPId = null, $cRMReference = null, $aEndPostcode = null, $bEndPostcode = null, \ArrayType\ArrayOfPortAndBandwidth $portAndBandwidths = null, \ArrayType\ArrayOfInt $termLengthInMonths = null, \ArrayType\ArrayOfLocationIdentifier $aEndLocationIdentifiers = null, \ArrayType\ArrayOfLocationIdentifier $bEndLocationIdentifiers = null, $aEndExcludeNeosOnnet = false, $bEndExcludeNeosOnnet = false, $isDiverse = false, $isManagedDIA = false, $installAmortisation = true, \ArrayType\ArrayOfString $chosenAccessTypes = null, \ArrayType\ArrayOfString $additionalServices = null, \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions = null)
    {
        $this
            ->setProductType($productType)
            ->setCustomerId($customerId)
            ->setAEndNNIId($aEndNNIId)
            ->setShadowVlanNNIId($shadowVlanNNIId)
            ->setAEndFloor($aEndFloor)
            ->setBEndFloor($bEndFloor)
            ->setAEndPoPId($aEndPoPId)
            ->setBEndPoPId($bEndPoPId)
            ->setCRMReference($cRMReference)
            ->setAEndPostcode($aEndPostcode)
            ->setBEndPostcode($bEndPostcode)
            ->setPortAndBandwidths($portAndBandwidths)
            ->setTermLengthInMonths($termLengthInMonths)
            ->setAEndLocationIdentifiers($aEndLocationIdentifiers)
            ->setBEndLocationIdentifiers($bEndLocationIdentifiers)
            ->setAEndExcludeNeosOnnet($aEndExcludeNeosOnnet)
            ->setBEndExcludeNeosOnnet($bEndExcludeNeosOnnet)
            ->setIsDiverse($isDiverse)
            ->setIsManagedDIA($isManagedDIA)
            ->setInstallAmortisation($installAmortisation)
            ->setChosenAccessTypes($chosenAccessTypes)
            ->setAdditionalServices($additionalServices)
            ->setCloudConnectOptions($cloudConnectOptions);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\CircuitDetails
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CircuitDetails
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get AEndNNIId value
     * @return int
     */
    public function getAEndNNIId()
    {
        return $this->AEndNNIId;
    }
    /**
     * Set AEndNNIId value
     * @param int $aEndNNIId
     * @return \StructType\CircuitDetails
     */
    public function setAEndNNIId($aEndNNIId = null)
    {
        // validation for constraint: int
        if (!is_null($aEndNNIId) && !(is_int($aEndNNIId) || ctype_digit($aEndNNIId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndNNIId, true), gettype($aEndNNIId)), __LINE__);
        }
        $this->AEndNNIId = $aEndNNIId;
        return $this;
    }
    /**
     * Get ShadowVlanNNIId value
     * @return int
     */
    public function getShadowVlanNNIId()
    {
        return $this->ShadowVlanNNIId;
    }
    /**
     * Set ShadowVlanNNIId value
     * @param int $shadowVlanNNIId
     * @return \StructType\CircuitDetails
     */
    public function setShadowVlanNNIId($shadowVlanNNIId = null)
    {
        // validation for constraint: int
        if (!is_null($shadowVlanNNIId) && !(is_int($shadowVlanNNIId) || ctype_digit($shadowVlanNNIId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shadowVlanNNIId, true), gettype($shadowVlanNNIId)), __LINE__);
        }
        $this->ShadowVlanNNIId = $shadowVlanNNIId;
        return $this;
    }
    /**
     * Get AEndFloor value
     * @return int
     */
    public function getAEndFloor()
    {
        return $this->AEndFloor;
    }
    /**
     * Set AEndFloor value
     * @param int $aEndFloor
     * @return \StructType\CircuitDetails
     */
    public function setAEndFloor($aEndFloor = null)
    {
        // validation for constraint: int
        if (!is_null($aEndFloor) && !(is_int($aEndFloor) || ctype_digit($aEndFloor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndFloor, true), gettype($aEndFloor)), __LINE__);
        }
        $this->AEndFloor = $aEndFloor;
        return $this;
    }
    /**
     * Get BEndFloor value
     * @return int
     */
    public function getBEndFloor()
    {
        return $this->BEndFloor;
    }
    /**
     * Set BEndFloor value
     * @param int $bEndFloor
     * @return \StructType\CircuitDetails
     */
    public function setBEndFloor($bEndFloor = null)
    {
        // validation for constraint: int
        if (!is_null($bEndFloor) && !(is_int($bEndFloor) || ctype_digit($bEndFloor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEndFloor, true), gettype($bEndFloor)), __LINE__);
        }
        $this->BEndFloor = $bEndFloor;
        return $this;
    }
    /**
     * Get AEndPoPId value
     * @return int
     */
    public function getAEndPoPId()
    {
        return $this->AEndPoPId;
    }
    /**
     * Set AEndPoPId value
     * @param int $aEndPoPId
     * @return \StructType\CircuitDetails
     */
    public function setAEndPoPId($aEndPoPId = null)
    {
        // validation for constraint: int
        if (!is_null($aEndPoPId) && !(is_int($aEndPoPId) || ctype_digit($aEndPoPId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndPoPId, true), gettype($aEndPoPId)), __LINE__);
        }
        $this->AEndPoPId = $aEndPoPId;
        return $this;
    }
    /**
     * Get BEndPoPId value
     * @return int
     */
    public function getBEndPoPId()
    {
        return $this->BEndPoPId;
    }
    /**
     * Set BEndPoPId value
     * @param int $bEndPoPId
     * @return \StructType\CircuitDetails
     */
    public function setBEndPoPId($bEndPoPId = null)
    {
        // validation for constraint: int
        if (!is_null($bEndPoPId) && !(is_int($bEndPoPId) || ctype_digit($bEndPoPId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEndPoPId, true), gettype($bEndPoPId)), __LINE__);
        }
        $this->BEndPoPId = $bEndPoPId;
        return $this;
    }
    /**
     * Get CRMReference value
     * @return string|null
     */
    public function getCRMReference()
    {
        return $this->CRMReference;
    }
    /**
     * Set CRMReference value
     * @param string $cRMReference
     * @return \StructType\CircuitDetails
     */
    public function setCRMReference($cRMReference = null)
    {
        // validation for constraint: string
        if (!is_null($cRMReference) && !is_string($cRMReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRMReference, true), gettype($cRMReference)), __LINE__);
        }
        $this->CRMReference = $cRMReference;
        return $this;
    }
    /**
     * Get AEndPostcode value
     * @return string|null
     */
    public function getAEndPostcode()
    {
        return $this->AEndPostcode;
    }
    /**
     * Set AEndPostcode value
     * @param string $aEndPostcode
     * @return \StructType\CircuitDetails
     */
    public function setAEndPostcode($aEndPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($aEndPostcode) && !is_string($aEndPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndPostcode, true), gettype($aEndPostcode)), __LINE__);
        }
        $this->AEndPostcode = $aEndPostcode;
        return $this;
    }
    /**
     * Get BEndPostcode value
     * @return string|null
     */
    public function getBEndPostcode()
    {
        return $this->BEndPostcode;
    }
    /**
     * Set BEndPostcode value
     * @param string $bEndPostcode
     * @return \StructType\CircuitDetails
     */
    public function setBEndPostcode($bEndPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($bEndPostcode) && !is_string($bEndPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndPostcode, true), gettype($bEndPostcode)), __LINE__);
        }
        $this->BEndPostcode = $bEndPostcode;
        return $this;
    }
    /**
     * Get PortAndBandwidths value
     * @return \ArrayType\ArrayOfPortAndBandwidth|null
     */
    public function getPortAndBandwidths()
    {
        return $this->PortAndBandwidths;
    }
    /**
     * Set PortAndBandwidths value
     * @param \ArrayType\ArrayOfPortAndBandwidth $portAndBandwidths
     * @return \StructType\CircuitDetails
     */
    public function setPortAndBandwidths(\ArrayType\ArrayOfPortAndBandwidth $portAndBandwidths = null)
    {
        $this->PortAndBandwidths = $portAndBandwidths;
        return $this;
    }
    /**
     * Get TermLengthInMonths value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getTermLengthInMonths()
    {
        return $this->TermLengthInMonths;
    }
    /**
     * Set TermLengthInMonths value
     * @param \ArrayType\ArrayOfInt $termLengthInMonths
     * @return \StructType\CircuitDetails
     */
    public function setTermLengthInMonths(\ArrayType\ArrayOfInt $termLengthInMonths = null)
    {
        $this->TermLengthInMonths = $termLengthInMonths;
        return $this;
    }
    /**
     * Get AEndLocationIdentifiers value
     * @return \ArrayType\ArrayOfLocationIdentifier|null
     */
    public function getAEndLocationIdentifiers()
    {
        return $this->AEndLocationIdentifiers;
    }
    /**
     * Set AEndLocationIdentifiers value
     * @param \ArrayType\ArrayOfLocationIdentifier $aEndLocationIdentifiers
     * @return \StructType\CircuitDetails
     */
    public function setAEndLocationIdentifiers(\ArrayType\ArrayOfLocationIdentifier $aEndLocationIdentifiers = null)
    {
        $this->AEndLocationIdentifiers = $aEndLocationIdentifiers;
        return $this;
    }
    /**
     * Get BEndLocationIdentifiers value
     * @return \ArrayType\ArrayOfLocationIdentifier|null
     */
    public function getBEndLocationIdentifiers()
    {
        return $this->BEndLocationIdentifiers;
    }
    /**
     * Set BEndLocationIdentifiers value
     * @param \ArrayType\ArrayOfLocationIdentifier $bEndLocationIdentifiers
     * @return \StructType\CircuitDetails
     */
    public function setBEndLocationIdentifiers(\ArrayType\ArrayOfLocationIdentifier $bEndLocationIdentifiers = null)
    {
        $this->BEndLocationIdentifiers = $bEndLocationIdentifiers;
        return $this;
    }
    /**
     * Get AEndExcludeNeosOnnet value
     * @return bool|null
     */
    public function getAEndExcludeNeosOnnet()
    {
        return $this->AEndExcludeNeosOnnet;
    }
    /**
     * Set AEndExcludeNeosOnnet value
     * @param bool $aEndExcludeNeosOnnet
     * @return \StructType\CircuitDetails
     */
    public function setAEndExcludeNeosOnnet($aEndExcludeNeosOnnet = false)
    {
        // validation for constraint: boolean
        if (!is_null($aEndExcludeNeosOnnet) && !is_bool($aEndExcludeNeosOnnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aEndExcludeNeosOnnet, true), gettype($aEndExcludeNeosOnnet)), __LINE__);
        }
        $this->AEndExcludeNeosOnnet = $aEndExcludeNeosOnnet;
        return $this;
    }
    /**
     * Get BEndExcludeNeosOnnet value
     * @return bool|null
     */
    public function getBEndExcludeNeosOnnet()
    {
        return $this->BEndExcludeNeosOnnet;
    }
    /**
     * Set BEndExcludeNeosOnnet value
     * @param bool $bEndExcludeNeosOnnet
     * @return \StructType\CircuitDetails
     */
    public function setBEndExcludeNeosOnnet($bEndExcludeNeosOnnet = false)
    {
        // validation for constraint: boolean
        if (!is_null($bEndExcludeNeosOnnet) && !is_bool($bEndExcludeNeosOnnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bEndExcludeNeosOnnet, true), gettype($bEndExcludeNeosOnnet)), __LINE__);
        }
        $this->BEndExcludeNeosOnnet = $bEndExcludeNeosOnnet;
        return $this;
    }
    /**
     * Get IsDiverse value
     * @return bool|null
     */
    public function getIsDiverse()
    {
        return $this->IsDiverse;
    }
    /**
     * Set IsDiverse value
     * @param bool $isDiverse
     * @return \StructType\CircuitDetails
     */
    public function setIsDiverse($isDiverse = false)
    {
        // validation for constraint: boolean
        if (!is_null($isDiverse) && !is_bool($isDiverse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDiverse, true), gettype($isDiverse)), __LINE__);
        }
        $this->IsDiverse = $isDiverse;
        return $this;
    }
    /**
     * Get IsManagedDIA value
     * @return bool|null
     */
    public function getIsManagedDIA()
    {
        return $this->IsManagedDIA;
    }
    /**
     * Set IsManagedDIA value
     * @param bool $isManagedDIA
     * @return \StructType\CircuitDetails
     */
    public function setIsManagedDIA($isManagedDIA = false)
    {
        // validation for constraint: boolean
        if (!is_null($isManagedDIA) && !is_bool($isManagedDIA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManagedDIA, true), gettype($isManagedDIA)), __LINE__);
        }
        $this->IsManagedDIA = $isManagedDIA;
        return $this;
    }
    /**
     * Get InstallAmortisation value
     * @return bool|null
     */
    public function getInstallAmortisation()
    {
        return $this->InstallAmortisation;
    }
    /**
     * Set InstallAmortisation value
     * @param bool $installAmortisation
     * @return \StructType\CircuitDetails
     */
    public function setInstallAmortisation($installAmortisation = true)
    {
        // validation for constraint: boolean
        if (!is_null($installAmortisation) && !is_bool($installAmortisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($installAmortisation, true), gettype($installAmortisation)), __LINE__);
        }
        $this->InstallAmortisation = $installAmortisation;
        return $this;
    }
    /**
     * Get ChosenAccessTypes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getChosenAccessTypes()
    {
        return $this->ChosenAccessTypes;
    }
    /**
     * Set ChosenAccessTypes value
     * @param \ArrayType\ArrayOfString $chosenAccessTypes
     * @return \StructType\CircuitDetails
     */
    public function setChosenAccessTypes(\ArrayType\ArrayOfString $chosenAccessTypes = null)
    {
        $this->ChosenAccessTypes = $chosenAccessTypes;
        return $this;
    }
    /**
     * Get AdditionalServices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalServices()
    {
        return $this->AdditionalServices;
    }
    /**
     * Set AdditionalServices value
     * @param \ArrayType\ArrayOfString $additionalServices
     * @return \StructType\CircuitDetails
     */
    public function setAdditionalServices(\ArrayType\ArrayOfString $additionalServices = null)
    {
        $this->AdditionalServices = $additionalServices;
        return $this;
    }
    /**
     * Get CloudConnectOptions value
     * @return \ArrayType\ArrayOfCloudConnectRequest|null
     */
    public function getCloudConnectOptions()
    {
        return $this->CloudConnectOptions;
    }
    /**
     * Set CloudConnectOptions value
     * @param \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions
     * @return \StructType\CircuitDetails
     */
    public function setCloudConnectOptions(\ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions = null)
    {
        $this->CloudConnectOptions = $cloudConnectOptions;
        return $this;
    }
}
