<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindQuotation StructType
 * @subpackage Structs
 */
class FindQuotation extends AbstractStructBase
{
    /**
     * The QuotationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuotationId;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApiKey;
    /**
     * Constructor method for FindQuotation
     * @uses FindQuotation::setQuotationId()
     * @uses FindQuotation::setUsername()
     * @uses FindQuotation::setApiKey()
     * @param int $quotationId
     * @param string $username
     * @param string $apiKey
     */
    public function __construct($quotationId = null, $username = null, $apiKey = null)
    {
        $this
            ->setQuotationId($quotationId)
            ->setUsername($username)
            ->setApiKey($apiKey);
    }
    /**
     * Get QuotationId value
     * @return int
     */
    public function getQuotationId()
    {
        return $this->QuotationId;
    }
    /**
     * Set QuotationId value
     * @param int $quotationId
     * @return \StructType\FindQuotation
     */
    public function setQuotationId($quotationId = null)
    {
        // validation for constraint: int
        if (!is_null($quotationId) && !(is_int($quotationId) || ctype_digit($quotationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotationId, true), gettype($quotationId)), __LINE__);
        }
        $this->QuotationId = $quotationId;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\FindQuotation
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get ApiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->ApiKey;
    }
    /**
     * Set ApiKey value
     * @param string $apiKey
     * @return \StructType\FindQuotation
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->ApiKey = $apiKey;
        return $this;
    }
}
