<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloudConnectProvider StructType
 * @subpackage Structs
 */
class CloudConnectProvider extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnabled;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Usage;
    /**
     * The SupportedBandwidths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt_1
     */
    public $SupportedBandwidths;
    /**
     * Constructor method for CloudConnectProvider
     * @uses CloudConnectProvider::setId()
     * @uses CloudConnectProvider::setIsEnabled()
     * @uses CloudConnectProvider::setName()
     * @uses CloudConnectProvider::setUsage()
     * @uses CloudConnectProvider::setSupportedBandwidths()
     * @param int $id
     * @param bool $isEnabled
     * @param string $name
     * @param string $usage
     * @param \ArrayType\ArrayOfInt_1 $supportedBandwidths
     */
    public function __construct($id = null, $isEnabled = null, $name = null, $usage = null, \ArrayType\ArrayOfInt_1 $supportedBandwidths = null)
    {
        $this
            ->setId($id)
            ->setIsEnabled($isEnabled)
            ->setName($name)
            ->setUsage($usage)
            ->setSupportedBandwidths($supportedBandwidths);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CloudConnectProvider
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsEnabled value
     * @return bool
     */
    public function getIsEnabled()
    {
        return $this->IsEnabled;
    }
    /**
     * Set IsEnabled value
     * @param bool $isEnabled
     * @return \StructType\CloudConnectProvider
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        $this->IsEnabled = $isEnabled;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CloudConnectProvider
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param string $usage
     * @return \StructType\CloudConnectProvider
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usage, true), gettype($usage)), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get SupportedBandwidths value
     * @return \ArrayType\ArrayOfInt_1|null
     */
    public function getSupportedBandwidths()
    {
        return $this->SupportedBandwidths;
    }
    /**
     * Set SupportedBandwidths value
     * @param \ArrayType\ArrayOfInt_1 $supportedBandwidths
     * @return \StructType\CloudConnectProvider
     */
    public function setSupportedBandwidths(\ArrayType\ArrayOfInt_1 $supportedBandwidths = null)
    {
        $this->SupportedBandwidths = $supportedBandwidths;
        return $this;
    }
}
