<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotationLine StructType
 * @subpackage Structs
 */
class QuotationLine extends AbstractStructBase
{
    /**
     * The QuotationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuotationId;
    /**
     * The QuotationLineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuotationLineId;
    /**
     * The DateCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateCreated;
    /**
     * The AEndMainLinkDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AEndMainLinkDistance;
    /**
     * The BEndMainLinkDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BEndMainLinkDistance;
    /**
     * The SetupPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SetupPrice;
    /**
     * The AnnualPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AnnualPrice;
    /**
     * The CircuitDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CircuitDetails
     */
    public $CircuitDetails;
    /**
     * The AEndAccessType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndAccessType;
    /**
     * The BEndAccessType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndAccessType;
    /**
     * The AEndProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndProductName;
    /**
     * The BEndProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndProductName;
    /**
     * The OnNetProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OnNetProductName;
    /**
     * The NNIEthernetBearerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NNIEthernetBearerReference;
    /**
     * The AEndPoPPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndPoPPostcode;
    /**
     * The BEndPoPPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndPoPPostcode;
    /**
     * The AEndPoPNodeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndPoPNodeReference;
    /**
     * The BEndPoPNodeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndPoPNodeReference;
    /**
     * The AdditionalServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalServices;
    /**
     * The AdditionalProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $AdditionalProperties;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for QuotationLine
     * @uses QuotationLine::setQuotationId()
     * @uses QuotationLine::setQuotationLineId()
     * @uses QuotationLine::setDateCreated()
     * @uses QuotationLine::setAEndMainLinkDistance()
     * @uses QuotationLine::setBEndMainLinkDistance()
     * @uses QuotationLine::setSetupPrice()
     * @uses QuotationLine::setAnnualPrice()
     * @uses QuotationLine::setCircuitDetails()
     * @uses QuotationLine::setAEndAccessType()
     * @uses QuotationLine::setBEndAccessType()
     * @uses QuotationLine::setAEndProductName()
     * @uses QuotationLine::setBEndProductName()
     * @uses QuotationLine::setOnNetProductName()
     * @uses QuotationLine::setNNIEthernetBearerReference()
     * @uses QuotationLine::setAEndPoPPostcode()
     * @uses QuotationLine::setBEndPoPPostcode()
     * @uses QuotationLine::setAEndPoPNodeReference()
     * @uses QuotationLine::setBEndPoPNodeReference()
     * @uses QuotationLine::setAdditionalServices()
     * @uses QuotationLine::setAdditionalProperties()
     * @uses QuotationLine::setErrorMessage()
     * @param int $quotationId
     * @param int $quotationLineId
     * @param string $dateCreated
     * @param float $aEndMainLinkDistance
     * @param float $bEndMainLinkDistance
     * @param float $setupPrice
     * @param float $annualPrice
     * @param \StructType\CircuitDetails $circuitDetails
     * @param string $aEndAccessType
     * @param string $bEndAccessType
     * @param string $aEndProductName
     * @param string $bEndProductName
     * @param string $onNetProductName
     * @param string $nNIEthernetBearerReference
     * @param string $aEndPoPPostcode
     * @param string $bEndPoPPostcode
     * @param string $aEndPoPNodeReference
     * @param string $bEndPoPNodeReference
     * @param \ArrayType\ArrayOfString $additionalServices
     * @param \ArrayType\ArrayOfItem $additionalProperties
     * @param string $errorMessage
     */
    public function __construct($quotationId = null, $quotationLineId = null, $dateCreated = null, $aEndMainLinkDistance = null, $bEndMainLinkDistance = null, $setupPrice = null, $annualPrice = null, \StructType\CircuitDetails $circuitDetails = null, $aEndAccessType = null, $bEndAccessType = null, $aEndProductName = null, $bEndProductName = null, $onNetProductName = null, $nNIEthernetBearerReference = null, $aEndPoPPostcode = null, $bEndPoPPostcode = null, $aEndPoPNodeReference = null, $bEndPoPNodeReference = null, \ArrayType\ArrayOfString $additionalServices = null, \ArrayType\ArrayOfItem $additionalProperties = null, $errorMessage = null)
    {
        $this
            ->setQuotationId($quotationId)
            ->setQuotationLineId($quotationLineId)
            ->setDateCreated($dateCreated)
            ->setAEndMainLinkDistance($aEndMainLinkDistance)
            ->setBEndMainLinkDistance($bEndMainLinkDistance)
            ->setSetupPrice($setupPrice)
            ->setAnnualPrice($annualPrice)
            ->setCircuitDetails($circuitDetails)
            ->setAEndAccessType($aEndAccessType)
            ->setBEndAccessType($bEndAccessType)
            ->setAEndProductName($aEndProductName)
            ->setBEndProductName($bEndProductName)
            ->setOnNetProductName($onNetProductName)
            ->setNNIEthernetBearerReference($nNIEthernetBearerReference)
            ->setAEndPoPPostcode($aEndPoPPostcode)
            ->setBEndPoPPostcode($bEndPoPPostcode)
            ->setAEndPoPNodeReference($aEndPoPNodeReference)
            ->setBEndPoPNodeReference($bEndPoPNodeReference)
            ->setAdditionalServices($additionalServices)
            ->setAdditionalProperties($additionalProperties)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get QuotationId value
     * @return int
     */
    public function getQuotationId()
    {
        return $this->QuotationId;
    }
    /**
     * Set QuotationId value
     * @param int $quotationId
     * @return \StructType\QuotationLine
     */
    public function setQuotationId($quotationId = null)
    {
        // validation for constraint: int
        if (!is_null($quotationId) && !(is_int($quotationId) || ctype_digit($quotationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotationId, true), gettype($quotationId)), __LINE__);
        }
        $this->QuotationId = $quotationId;
        return $this;
    }
    /**
     * Get QuotationLineId value
     * @return int
     */
    public function getQuotationLineId()
    {
        return $this->QuotationLineId;
    }
    /**
     * Set QuotationLineId value
     * @param int $quotationLineId
     * @return \StructType\QuotationLine
     */
    public function setQuotationLineId($quotationLineId = null)
    {
        // validation for constraint: int
        if (!is_null($quotationLineId) && !(is_int($quotationLineId) || ctype_digit($quotationLineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotationLineId, true), gettype($quotationLineId)), __LINE__);
        }
        $this->QuotationLineId = $quotationLineId;
        return $this;
    }
    /**
     * Get DateCreated value
     * @return string
     */
    public function getDateCreated()
    {
        return $this->DateCreated;
    }
    /**
     * Set DateCreated value
     * @param string $dateCreated
     * @return \StructType\QuotationLine
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->DateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get AEndMainLinkDistance value
     * @return float
     */
    public function getAEndMainLinkDistance()
    {
        return $this->AEndMainLinkDistance;
    }
    /**
     * Set AEndMainLinkDistance value
     * @param float $aEndMainLinkDistance
     * @return \StructType\QuotationLine
     */
    public function setAEndMainLinkDistance($aEndMainLinkDistance = null)
    {
        // validation for constraint: float
        if (!is_null($aEndMainLinkDistance) && !(is_float($aEndMainLinkDistance) || is_numeric($aEndMainLinkDistance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aEndMainLinkDistance, true), gettype($aEndMainLinkDistance)), __LINE__);
        }
        $this->AEndMainLinkDistance = $aEndMainLinkDistance;
        return $this;
    }
    /**
     * Get BEndMainLinkDistance value
     * @return float
     */
    public function getBEndMainLinkDistance()
    {
        return $this->BEndMainLinkDistance;
    }
    /**
     * Set BEndMainLinkDistance value
     * @param float $bEndMainLinkDistance
     * @return \StructType\QuotationLine
     */
    public function setBEndMainLinkDistance($bEndMainLinkDistance = null)
    {
        // validation for constraint: float
        if (!is_null($bEndMainLinkDistance) && !(is_float($bEndMainLinkDistance) || is_numeric($bEndMainLinkDistance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bEndMainLinkDistance, true), gettype($bEndMainLinkDistance)), __LINE__);
        }
        $this->BEndMainLinkDistance = $bEndMainLinkDistance;
        return $this;
    }
    /**
     * Get SetupPrice value
     * @return float
     */
    public function getSetupPrice()
    {
        return $this->SetupPrice;
    }
    /**
     * Set SetupPrice value
     * @param float $setupPrice
     * @return \StructType\QuotationLine
     */
    public function setSetupPrice($setupPrice = null)
    {
        // validation for constraint: float
        if (!is_null($setupPrice) && !(is_float($setupPrice) || is_numeric($setupPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($setupPrice, true), gettype($setupPrice)), __LINE__);
        }
        $this->SetupPrice = $setupPrice;
        return $this;
    }
    /**
     * Get AnnualPrice value
     * @return float
     */
    public function getAnnualPrice()
    {
        return $this->AnnualPrice;
    }
    /**
     * Set AnnualPrice value
     * @param float $annualPrice
     * @return \StructType\QuotationLine
     */
    public function setAnnualPrice($annualPrice = null)
    {
        // validation for constraint: float
        if (!is_null($annualPrice) && !(is_float($annualPrice) || is_numeric($annualPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualPrice, true), gettype($annualPrice)), __LINE__);
        }
        $this->AnnualPrice = $annualPrice;
        return $this;
    }
    /**
     * Get CircuitDetails value
     * @return \StructType\CircuitDetails|null
     */
    public function getCircuitDetails()
    {
        return $this->CircuitDetails;
    }
    /**
     * Set CircuitDetails value
     * @param \StructType\CircuitDetails $circuitDetails
     * @return \StructType\QuotationLine
     */
    public function setCircuitDetails(\StructType\CircuitDetails $circuitDetails = null)
    {
        $this->CircuitDetails = $circuitDetails;
        return $this;
    }
    /**
     * Get AEndAccessType value
     * @return string|null
     */
    public function getAEndAccessType()
    {
        return $this->AEndAccessType;
    }
    /**
     * Set AEndAccessType value
     * @param string $aEndAccessType
     * @return \StructType\QuotationLine
     */
    public function setAEndAccessType($aEndAccessType = null)
    {
        // validation for constraint: string
        if (!is_null($aEndAccessType) && !is_string($aEndAccessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndAccessType, true), gettype($aEndAccessType)), __LINE__);
        }
        $this->AEndAccessType = $aEndAccessType;
        return $this;
    }
    /**
     * Get BEndAccessType value
     * @return string|null
     */
    public function getBEndAccessType()
    {
        return $this->BEndAccessType;
    }
    /**
     * Set BEndAccessType value
     * @param string $bEndAccessType
     * @return \StructType\QuotationLine
     */
    public function setBEndAccessType($bEndAccessType = null)
    {
        // validation for constraint: string
        if (!is_null($bEndAccessType) && !is_string($bEndAccessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndAccessType, true), gettype($bEndAccessType)), __LINE__);
        }
        $this->BEndAccessType = $bEndAccessType;
        return $this;
    }
    /**
     * Get AEndProductName value
     * @return string|null
     */
    public function getAEndProductName()
    {
        return $this->AEndProductName;
    }
    /**
     * Set AEndProductName value
     * @param string $aEndProductName
     * @return \StructType\QuotationLine
     */
    public function setAEndProductName($aEndProductName = null)
    {
        // validation for constraint: string
        if (!is_null($aEndProductName) && !is_string($aEndProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndProductName, true), gettype($aEndProductName)), __LINE__);
        }
        $this->AEndProductName = $aEndProductName;
        return $this;
    }
    /**
     * Get BEndProductName value
     * @return string|null
     */
    public function getBEndProductName()
    {
        return $this->BEndProductName;
    }
    /**
     * Set BEndProductName value
     * @param string $bEndProductName
     * @return \StructType\QuotationLine
     */
    public function setBEndProductName($bEndProductName = null)
    {
        // validation for constraint: string
        if (!is_null($bEndProductName) && !is_string($bEndProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndProductName, true), gettype($bEndProductName)), __LINE__);
        }
        $this->BEndProductName = $bEndProductName;
        return $this;
    }
    /**
     * Get OnNetProductName value
     * @return string|null
     */
    public function getOnNetProductName()
    {
        return $this->OnNetProductName;
    }
    /**
     * Set OnNetProductName value
     * @param string $onNetProductName
     * @return \StructType\QuotationLine
     */
    public function setOnNetProductName($onNetProductName = null)
    {
        // validation for constraint: string
        if (!is_null($onNetProductName) && !is_string($onNetProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onNetProductName, true), gettype($onNetProductName)), __LINE__);
        }
        $this->OnNetProductName = $onNetProductName;
        return $this;
    }
    /**
     * Get NNIEthernetBearerReference value
     * @return string|null
     */
    public function getNNIEthernetBearerReference()
    {
        return $this->NNIEthernetBearerReference;
    }
    /**
     * Set NNIEthernetBearerReference value
     * @param string $nNIEthernetBearerReference
     * @return \StructType\QuotationLine
     */
    public function setNNIEthernetBearerReference($nNIEthernetBearerReference = null)
    {
        // validation for constraint: string
        if (!is_null($nNIEthernetBearerReference) && !is_string($nNIEthernetBearerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nNIEthernetBearerReference, true), gettype($nNIEthernetBearerReference)), __LINE__);
        }
        $this->NNIEthernetBearerReference = $nNIEthernetBearerReference;
        return $this;
    }
    /**
     * Get AEndPoPPostcode value
     * @return string|null
     */
    public function getAEndPoPPostcode()
    {
        return $this->AEndPoPPostcode;
    }
    /**
     * Set AEndPoPPostcode value
     * @param string $aEndPoPPostcode
     * @return \StructType\QuotationLine
     */
    public function setAEndPoPPostcode($aEndPoPPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($aEndPoPPostcode) && !is_string($aEndPoPPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndPoPPostcode, true), gettype($aEndPoPPostcode)), __LINE__);
        }
        $this->AEndPoPPostcode = $aEndPoPPostcode;
        return $this;
    }
    /**
     * Get BEndPoPPostcode value
     * @return string|null
     */
    public function getBEndPoPPostcode()
    {
        return $this->BEndPoPPostcode;
    }
    /**
     * Set BEndPoPPostcode value
     * @param string $bEndPoPPostcode
     * @return \StructType\QuotationLine
     */
    public function setBEndPoPPostcode($bEndPoPPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($bEndPoPPostcode) && !is_string($bEndPoPPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndPoPPostcode, true), gettype($bEndPoPPostcode)), __LINE__);
        }
        $this->BEndPoPPostcode = $bEndPoPPostcode;
        return $this;
    }
    /**
     * Get AEndPoPNodeReference value
     * @return string|null
     */
    public function getAEndPoPNodeReference()
    {
        return $this->AEndPoPNodeReference;
    }
    /**
     * Set AEndPoPNodeReference value
     * @param string $aEndPoPNodeReference
     * @return \StructType\QuotationLine
     */
    public function setAEndPoPNodeReference($aEndPoPNodeReference = null)
    {
        // validation for constraint: string
        if (!is_null($aEndPoPNodeReference) && !is_string($aEndPoPNodeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndPoPNodeReference, true), gettype($aEndPoPNodeReference)), __LINE__);
        }
        $this->AEndPoPNodeReference = $aEndPoPNodeReference;
        return $this;
    }
    /**
     * Get BEndPoPNodeReference value
     * @return string|null
     */
    public function getBEndPoPNodeReference()
    {
        return $this->BEndPoPNodeReference;
    }
    /**
     * Set BEndPoPNodeReference value
     * @param string $bEndPoPNodeReference
     * @return \StructType\QuotationLine
     */
    public function setBEndPoPNodeReference($bEndPoPNodeReference = null)
    {
        // validation for constraint: string
        if (!is_null($bEndPoPNodeReference) && !is_string($bEndPoPNodeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndPoPNodeReference, true), gettype($bEndPoPNodeReference)), __LINE__);
        }
        $this->BEndPoPNodeReference = $bEndPoPNodeReference;
        return $this;
    }
    /**
     * Get AdditionalServices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalServices()
    {
        return $this->AdditionalServices;
    }
    /**
     * Set AdditionalServices value
     * @param \ArrayType\ArrayOfString $additionalServices
     * @return \StructType\QuotationLine
     */
    public function setAdditionalServices(\ArrayType\ArrayOfString $additionalServices = null)
    {
        $this->AdditionalServices = $additionalServices;
        return $this;
    }
    /**
     * Get AdditionalProperties value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getAdditionalProperties()
    {
        return $this->AdditionalProperties;
    }
    /**
     * Set AdditionalProperties value
     * @param \ArrayType\ArrayOfItem $additionalProperties
     * @return \StructType\QuotationLine
     */
    public function setAdditionalProperties(\ArrayType\ArrayOfItem $additionalProperties = null)
    {
        $this->AdditionalProperties = $additionalProperties;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\QuotationLine
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
