<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Types StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Types
 * @subpackage Structs
 */
class Types extends AbstractStructBase
{
    /**
     * The ProductTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $ProductTypes;
    /**
     * The PortTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $PortTypes;
    /**
     * The Bandwidths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $Bandwidths;
    /**
     * The TermLengths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $TermLengths;
    /**
     * The AccessTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AccessTypes;
    /**
     * The CloudConnectProviders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCloudConnectProvider
     */
    public $CloudConnectProviders;
    /**
     * Constructor method for Types
     * @uses Types::setProductTypes()
     * @uses Types::setPortTypes()
     * @uses Types::setBandwidths()
     * @uses Types::setTermLengths()
     * @uses Types::setAccessTypes()
     * @uses Types::setCloudConnectProviders()
     * @param \ArrayType\ArrayOfItem $productTypes
     * @param \ArrayType\ArrayOfItem $portTypes
     * @param \ArrayType\ArrayOfItem $bandwidths
     * @param \ArrayType\ArrayOfItem $termLengths
     * @param \ArrayType\ArrayOfString $accessTypes
     * @param \ArrayType\ArrayOfCloudConnectProvider $cloudConnectProviders
     */
    public function __construct(\ArrayType\ArrayOfItem $productTypes = null, \ArrayType\ArrayOfItem $portTypes = null, \ArrayType\ArrayOfItem $bandwidths = null, \ArrayType\ArrayOfItem $termLengths = null, \ArrayType\ArrayOfString $accessTypes = null, \ArrayType\ArrayOfCloudConnectProvider $cloudConnectProviders = null)
    {
        $this
            ->setProductTypes($productTypes)
            ->setPortTypes($portTypes)
            ->setBandwidths($bandwidths)
            ->setTermLengths($termLengths)
            ->setAccessTypes($accessTypes)
            ->setCloudConnectProviders($cloudConnectProviders);
    }
    /**
     * Get ProductTypes value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getProductTypes()
    {
        return $this->ProductTypes;
    }
    /**
     * Set ProductTypes value
     * @param \ArrayType\ArrayOfItem $productTypes
     * @return \StructType\Types
     */
    public function setProductTypes(\ArrayType\ArrayOfItem $productTypes = null)
    {
        $this->ProductTypes = $productTypes;
        return $this;
    }
    /**
     * Get PortTypes value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getPortTypes()
    {
        return $this->PortTypes;
    }
    /**
     * Set PortTypes value
     * @param \ArrayType\ArrayOfItem $portTypes
     * @return \StructType\Types
     */
    public function setPortTypes(\ArrayType\ArrayOfItem $portTypes = null)
    {
        $this->PortTypes = $portTypes;
        return $this;
    }
    /**
     * Get Bandwidths value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getBandwidths()
    {
        return $this->Bandwidths;
    }
    /**
     * Set Bandwidths value
     * @param \ArrayType\ArrayOfItem $bandwidths
     * @return \StructType\Types
     */
    public function setBandwidths(\ArrayType\ArrayOfItem $bandwidths = null)
    {
        $this->Bandwidths = $bandwidths;
        return $this;
    }
    /**
     * Get TermLengths value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getTermLengths()
    {
        return $this->TermLengths;
    }
    /**
     * Set TermLengths value
     * @param \ArrayType\ArrayOfItem $termLengths
     * @return \StructType\Types
     */
    public function setTermLengths(\ArrayType\ArrayOfItem $termLengths = null)
    {
        $this->TermLengths = $termLengths;
        return $this;
    }
    /**
     * Get AccessTypes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAccessTypes()
    {
        return $this->AccessTypes;
    }
    /**
     * Set AccessTypes value
     * @param \ArrayType\ArrayOfString $accessTypes
     * @return \StructType\Types
     */
    public function setAccessTypes(\ArrayType\ArrayOfString $accessTypes = null)
    {
        $this->AccessTypes = $accessTypes;
        return $this;
    }
    /**
     * Get CloudConnectProviders value
     * @return \ArrayType\ArrayOfCloudConnectProvider|null
     */
    public function getCloudConnectProviders()
    {
        return $this->CloudConnectProviders;
    }
    /**
     * Set CloudConnectProviders value
     * @param \ArrayType\ArrayOfCloudConnectProvider $cloudConnectProviders
     * @return \StructType\Types
     */
    public function setCloudConnectProviders(\ArrayType\ArrayOfCloudConnectProvider $cloudConnectProviders = null)
    {
        $this->CloudConnectProviders = $cloudConnectProviders;
        return $this;
    }
}
