<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CircuitDetails StructType
 * @subpackage Structs
 */
class CircuitDetails extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductType;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The AEndNNIId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndNNIId;
    /**
     * The ShadowVlanNNIId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ShadowVlanNNIId;
    /**
     * The Bandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Bandwidth;
    /**
     * The TermLengthInMonths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TermLengthInMonths;
    /**
     * The AEndFloor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndFloor;
    /**
     * The BEndFloor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BEndFloor;
    /**
     * The AEndPoPId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndPoPId;
    /**
     * The BEndPoPId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BEndPoPId;
    /**
     * The AEndColtBuildingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AEndColtBuildingId;
    /**
     * The BEndColtBuildingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BEndColtBuildingId;
    /**
     * The CRMReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CRMReference;
    /**
     * The AEndPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndPostcode;
    /**
     * The BEndPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndPostcode;
    /**
     * The AEndPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AEndPort;
    /**
     * The BEndPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $BEndPort;
    /**
     * The AEndExcludeNeosOnnet
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AEndExcludeNeosOnnet;
    /**
     * The BEndExcludeNeosOnnet
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $BEndExcludeNeosOnnet;
    /**
     * The IsDiverse
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDiverse;
    /**
     * The IsManagedDIA
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsManagedDIA;
    /**
     * The InstallAmortisation
     * Meta information extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InstallAmortisation;
    /**
     * The ChosenAccessTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ChosenAccessTypes;
    /**
     * The AdditionalServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalServices;
    /**
     * The CloudConnectOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCloudConnectRequest
     */
    public $CloudConnectOptions;
    /**
     * Constructor method for CircuitDetails
     * @uses CircuitDetails::setProductType()
     * @uses CircuitDetails::setCustomerId()
     * @uses CircuitDetails::setAEndNNIId()
     * @uses CircuitDetails::setShadowVlanNNIId()
     * @uses CircuitDetails::setBandwidth()
     * @uses CircuitDetails::setTermLengthInMonths()
     * @uses CircuitDetails::setAEndFloor()
     * @uses CircuitDetails::setBEndFloor()
     * @uses CircuitDetails::setAEndPoPId()
     * @uses CircuitDetails::setBEndPoPId()
     * @uses CircuitDetails::setAEndColtBuildingId()
     * @uses CircuitDetails::setBEndColtBuildingId()
     * @uses CircuitDetails::setCRMReference()
     * @uses CircuitDetails::setAEndPostcode()
     * @uses CircuitDetails::setBEndPostcode()
     * @uses CircuitDetails::setAEndPort()
     * @uses CircuitDetails::setBEndPort()
     * @uses CircuitDetails::setAEndExcludeNeosOnnet()
     * @uses CircuitDetails::setBEndExcludeNeosOnnet()
     * @uses CircuitDetails::setIsDiverse()
     * @uses CircuitDetails::setIsManagedDIA()
     * @uses CircuitDetails::setInstallAmortisation()
     * @uses CircuitDetails::setChosenAccessTypes()
     * @uses CircuitDetails::setAdditionalServices()
     * @uses CircuitDetails::setCloudConnectOptions()
     * @param string $productType
     * @param int $customerId
     * @param int $aEndNNIId
     * @param int $shadowVlanNNIId
     * @param int $bandwidth
     * @param int $termLengthInMonths
     * @param int $aEndFloor
     * @param int $bEndFloor
     * @param int $aEndPoPId
     * @param int $bEndPoPId
     * @param int $aEndColtBuildingId
     * @param int $bEndColtBuildingId
     * @param string $cRMReference
     * @param string $aEndPostcode
     * @param string $bEndPostcode
     * @param \ArrayType\ArrayOfString $aEndPort
     * @param \ArrayType\ArrayOfString $bEndPort
     * @param bool $aEndExcludeNeosOnnet
     * @param bool $bEndExcludeNeosOnnet
     * @param bool $isDiverse
     * @param bool $isManagedDIA
     * @param bool $installAmortisation
     * @param \ArrayType\ArrayOfString $chosenAccessTypes
     * @param \ArrayType\ArrayOfString $additionalServices
     * @param \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions
     */
    public function __construct($productType = null, $customerId = null, $aEndNNIId = null, $shadowVlanNNIId = null, $bandwidth = null, $termLengthInMonths = null, $aEndFloor = null, $bEndFloor = null, $aEndPoPId = null, $bEndPoPId = null, $aEndColtBuildingId = null, $bEndColtBuildingId = null, $cRMReference = null, $aEndPostcode = null, $bEndPostcode = null, \ArrayType\ArrayOfString $aEndPort = null, \ArrayType\ArrayOfString $bEndPort = null, $aEndExcludeNeosOnnet = false, $bEndExcludeNeosOnnet = false, $isDiverse = false, $isManagedDIA = false, $installAmortisation = true, \ArrayType\ArrayOfString $chosenAccessTypes = null, \ArrayType\ArrayOfString $additionalServices = null, \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions = null)
    {
        $this
            ->setProductType($productType)
            ->setCustomerId($customerId)
            ->setAEndNNIId($aEndNNIId)
            ->setShadowVlanNNIId($shadowVlanNNIId)
            ->setBandwidth($bandwidth)
            ->setTermLengthInMonths($termLengthInMonths)
            ->setAEndFloor($aEndFloor)
            ->setBEndFloor($bEndFloor)
            ->setAEndPoPId($aEndPoPId)
            ->setBEndPoPId($bEndPoPId)
            ->setAEndColtBuildingId($aEndColtBuildingId)
            ->setBEndColtBuildingId($bEndColtBuildingId)
            ->setCRMReference($cRMReference)
            ->setAEndPostcode($aEndPostcode)
            ->setBEndPostcode($bEndPostcode)
            ->setAEndPort($aEndPort)
            ->setBEndPort($bEndPort)
            ->setAEndExcludeNeosOnnet($aEndExcludeNeosOnnet)
            ->setBEndExcludeNeosOnnet($bEndExcludeNeosOnnet)
            ->setIsDiverse($isDiverse)
            ->setIsManagedDIA($isManagedDIA)
            ->setInstallAmortisation($installAmortisation)
            ->setChosenAccessTypes($chosenAccessTypes)
            ->setAdditionalServices($additionalServices)
            ->setCloudConnectOptions($cloudConnectOptions);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\CircuitDetails
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CircuitDetails
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get AEndNNIId value
     * @return int
     */
    public function getAEndNNIId()
    {
        return $this->AEndNNIId;
    }
    /**
     * Set AEndNNIId value
     * @param int $aEndNNIId
     * @return \StructType\CircuitDetails
     */
    public function setAEndNNIId($aEndNNIId = null)
    {
        // validation for constraint: int
        if (!is_null($aEndNNIId) && !(is_int($aEndNNIId) || ctype_digit($aEndNNIId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndNNIId, true), gettype($aEndNNIId)), __LINE__);
        }
        $this->AEndNNIId = $aEndNNIId;
        return $this;
    }
    /**
     * Get ShadowVlanNNIId value
     * @return int
     */
    public function getShadowVlanNNIId()
    {
        return $this->ShadowVlanNNIId;
    }
    /**
     * Set ShadowVlanNNIId value
     * @param int $shadowVlanNNIId
     * @return \StructType\CircuitDetails
     */
    public function setShadowVlanNNIId($shadowVlanNNIId = null)
    {
        // validation for constraint: int
        if (!is_null($shadowVlanNNIId) && !(is_int($shadowVlanNNIId) || ctype_digit($shadowVlanNNIId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shadowVlanNNIId, true), gettype($shadowVlanNNIId)), __LINE__);
        }
        $this->ShadowVlanNNIId = $shadowVlanNNIId;
        return $this;
    }
    /**
     * Get Bandwidth value
     * @return int
     */
    public function getBandwidth()
    {
        return $this->Bandwidth;
    }
    /**
     * Set Bandwidth value
     * @param int $bandwidth
     * @return \StructType\CircuitDetails
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: int
        if (!is_null($bandwidth) && !(is_int($bandwidth) || ctype_digit($bandwidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->Bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get TermLengthInMonths value
     * @return int
     */
    public function getTermLengthInMonths()
    {
        return $this->TermLengthInMonths;
    }
    /**
     * Set TermLengthInMonths value
     * @param int $termLengthInMonths
     * @return \StructType\CircuitDetails
     */
    public function setTermLengthInMonths($termLengthInMonths = null)
    {
        // validation for constraint: int
        if (!is_null($termLengthInMonths) && !(is_int($termLengthInMonths) || ctype_digit($termLengthInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($termLengthInMonths, true), gettype($termLengthInMonths)), __LINE__);
        }
        $this->TermLengthInMonths = $termLengthInMonths;
        return $this;
    }
    /**
     * Get AEndFloor value
     * @return int
     */
    public function getAEndFloor()
    {
        return $this->AEndFloor;
    }
    /**
     * Set AEndFloor value
     * @param int $aEndFloor
     * @return \StructType\CircuitDetails
     */
    public function setAEndFloor($aEndFloor = null)
    {
        // validation for constraint: int
        if (!is_null($aEndFloor) && !(is_int($aEndFloor) || ctype_digit($aEndFloor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndFloor, true), gettype($aEndFloor)), __LINE__);
        }
        $this->AEndFloor = $aEndFloor;
        return $this;
    }
    /**
     * Get BEndFloor value
     * @return int
     */
    public function getBEndFloor()
    {
        return $this->BEndFloor;
    }
    /**
     * Set BEndFloor value
     * @param int $bEndFloor
     * @return \StructType\CircuitDetails
     */
    public function setBEndFloor($bEndFloor = null)
    {
        // validation for constraint: int
        if (!is_null($bEndFloor) && !(is_int($bEndFloor) || ctype_digit($bEndFloor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEndFloor, true), gettype($bEndFloor)), __LINE__);
        }
        $this->BEndFloor = $bEndFloor;
        return $this;
    }
    /**
     * Get AEndPoPId value
     * @return int
     */
    public function getAEndPoPId()
    {
        return $this->AEndPoPId;
    }
    /**
     * Set AEndPoPId value
     * @param int $aEndPoPId
     * @return \StructType\CircuitDetails
     */
    public function setAEndPoPId($aEndPoPId = null)
    {
        // validation for constraint: int
        if (!is_null($aEndPoPId) && !(is_int($aEndPoPId) || ctype_digit($aEndPoPId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndPoPId, true), gettype($aEndPoPId)), __LINE__);
        }
        $this->AEndPoPId = $aEndPoPId;
        return $this;
    }
    /**
     * Get BEndPoPId value
     * @return int
     */
    public function getBEndPoPId()
    {
        return $this->BEndPoPId;
    }
    /**
     * Set BEndPoPId value
     * @param int $bEndPoPId
     * @return \StructType\CircuitDetails
     */
    public function setBEndPoPId($bEndPoPId = null)
    {
        // validation for constraint: int
        if (!is_null($bEndPoPId) && !(is_int($bEndPoPId) || ctype_digit($bEndPoPId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEndPoPId, true), gettype($bEndPoPId)), __LINE__);
        }
        $this->BEndPoPId = $bEndPoPId;
        return $this;
    }
    /**
     * Get AEndColtBuildingId value
     * @return int
     */
    public function getAEndColtBuildingId()
    {
        return $this->AEndColtBuildingId;
    }
    /**
     * Set AEndColtBuildingId value
     * @param int $aEndColtBuildingId
     * @return \StructType\CircuitDetails
     */
    public function setAEndColtBuildingId($aEndColtBuildingId = null)
    {
        // validation for constraint: int
        if (!is_null($aEndColtBuildingId) && !(is_int($aEndColtBuildingId) || ctype_digit($aEndColtBuildingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aEndColtBuildingId, true), gettype($aEndColtBuildingId)), __LINE__);
        }
        $this->AEndColtBuildingId = $aEndColtBuildingId;
        return $this;
    }
    /**
     * Get BEndColtBuildingId value
     * @return int
     */
    public function getBEndColtBuildingId()
    {
        return $this->BEndColtBuildingId;
    }
    /**
     * Set BEndColtBuildingId value
     * @param int $bEndColtBuildingId
     * @return \StructType\CircuitDetails
     */
    public function setBEndColtBuildingId($bEndColtBuildingId = null)
    {
        // validation for constraint: int
        if (!is_null($bEndColtBuildingId) && !(is_int($bEndColtBuildingId) || ctype_digit($bEndColtBuildingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEndColtBuildingId, true), gettype($bEndColtBuildingId)), __LINE__);
        }
        $this->BEndColtBuildingId = $bEndColtBuildingId;
        return $this;
    }
    /**
     * Get CRMReference value
     * @return string|null
     */
    public function getCRMReference()
    {
        return $this->CRMReference;
    }
    /**
     * Set CRMReference value
     * @param string $cRMReference
     * @return \StructType\CircuitDetails
     */
    public function setCRMReference($cRMReference = null)
    {
        // validation for constraint: string
        if (!is_null($cRMReference) && !is_string($cRMReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRMReference, true), gettype($cRMReference)), __LINE__);
        }
        $this->CRMReference = $cRMReference;
        return $this;
    }
    /**
     * Get AEndPostcode value
     * @return string|null
     */
    public function getAEndPostcode()
    {
        return $this->AEndPostcode;
    }
    /**
     * Set AEndPostcode value
     * @param string $aEndPostcode
     * @return \StructType\CircuitDetails
     */
    public function setAEndPostcode($aEndPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($aEndPostcode) && !is_string($aEndPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndPostcode, true), gettype($aEndPostcode)), __LINE__);
        }
        $this->AEndPostcode = $aEndPostcode;
        return $this;
    }
    /**
     * Get BEndPostcode value
     * @return string|null
     */
    public function getBEndPostcode()
    {
        return $this->BEndPostcode;
    }
    /**
     * Set BEndPostcode value
     * @param string $bEndPostcode
     * @return \StructType\CircuitDetails
     */
    public function setBEndPostcode($bEndPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($bEndPostcode) && !is_string($bEndPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndPostcode, true), gettype($bEndPostcode)), __LINE__);
        }
        $this->BEndPostcode = $bEndPostcode;
        return $this;
    }
    /**
     * Get AEndPort value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAEndPort()
    {
        return $this->AEndPort;
    }
    /**
     * Set AEndPort value
     * @param \ArrayType\ArrayOfString $aEndPort
     * @return \StructType\CircuitDetails
     */
    public function setAEndPort(\ArrayType\ArrayOfString $aEndPort = null)
    {
        $this->AEndPort = $aEndPort;
        return $this;
    }
    /**
     * Get BEndPort value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getBEndPort()
    {
        return $this->BEndPort;
    }
    /**
     * Set BEndPort value
     * @param \ArrayType\ArrayOfString $bEndPort
     * @return \StructType\CircuitDetails
     */
    public function setBEndPort(\ArrayType\ArrayOfString $bEndPort = null)
    {
        $this->BEndPort = $bEndPort;
        return $this;
    }
    /**
     * Get AEndExcludeNeosOnnet value
     * @return bool|null
     */
    public function getAEndExcludeNeosOnnet()
    {
        return $this->AEndExcludeNeosOnnet;
    }
    /**
     * Set AEndExcludeNeosOnnet value
     * @param bool $aEndExcludeNeosOnnet
     * @return \StructType\CircuitDetails
     */
    public function setAEndExcludeNeosOnnet($aEndExcludeNeosOnnet = false)
    {
        // validation for constraint: boolean
        if (!is_null($aEndExcludeNeosOnnet) && !is_bool($aEndExcludeNeosOnnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aEndExcludeNeosOnnet, true), gettype($aEndExcludeNeosOnnet)), __LINE__);
        }
        $this->AEndExcludeNeosOnnet = $aEndExcludeNeosOnnet;
        return $this;
    }
    /**
     * Get BEndExcludeNeosOnnet value
     * @return bool|null
     */
    public function getBEndExcludeNeosOnnet()
    {
        return $this->BEndExcludeNeosOnnet;
    }
    /**
     * Set BEndExcludeNeosOnnet value
     * @param bool $bEndExcludeNeosOnnet
     * @return \StructType\CircuitDetails
     */
    public function setBEndExcludeNeosOnnet($bEndExcludeNeosOnnet = false)
    {
        // validation for constraint: boolean
        if (!is_null($bEndExcludeNeosOnnet) && !is_bool($bEndExcludeNeosOnnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bEndExcludeNeosOnnet, true), gettype($bEndExcludeNeosOnnet)), __LINE__);
        }
        $this->BEndExcludeNeosOnnet = $bEndExcludeNeosOnnet;
        return $this;
    }
    /**
     * Get IsDiverse value
     * @return bool|null
     */
    public function getIsDiverse()
    {
        return $this->IsDiverse;
    }
    /**
     * Set IsDiverse value
     * @param bool $isDiverse
     * @return \StructType\CircuitDetails
     */
    public function setIsDiverse($isDiverse = false)
    {
        // validation for constraint: boolean
        if (!is_null($isDiverse) && !is_bool($isDiverse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDiverse, true), gettype($isDiverse)), __LINE__);
        }
        $this->IsDiverse = $isDiverse;
        return $this;
    }
    /**
     * Get IsManagedDIA value
     * @return bool|null
     */
    public function getIsManagedDIA()
    {
        return $this->IsManagedDIA;
    }
    /**
     * Set IsManagedDIA value
     * @param bool $isManagedDIA
     * @return \StructType\CircuitDetails
     */
    public function setIsManagedDIA($isManagedDIA = false)
    {
        // validation for constraint: boolean
        if (!is_null($isManagedDIA) && !is_bool($isManagedDIA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManagedDIA, true), gettype($isManagedDIA)), __LINE__);
        }
        $this->IsManagedDIA = $isManagedDIA;
        return $this;
    }
    /**
     * Get InstallAmortisation value
     * @return bool|null
     */
    public function getInstallAmortisation()
    {
        return $this->InstallAmortisation;
    }
    /**
     * Set InstallAmortisation value
     * @param bool $installAmortisation
     * @return \StructType\CircuitDetails
     */
    public function setInstallAmortisation($installAmortisation = true)
    {
        // validation for constraint: boolean
        if (!is_null($installAmortisation) && !is_bool($installAmortisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($installAmortisation, true), gettype($installAmortisation)), __LINE__);
        }
        $this->InstallAmortisation = $installAmortisation;
        return $this;
    }
    /**
     * Get ChosenAccessTypes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getChosenAccessTypes()
    {
        return $this->ChosenAccessTypes;
    }
    /**
     * Set ChosenAccessTypes value
     * @param \ArrayType\ArrayOfString $chosenAccessTypes
     * @return \StructType\CircuitDetails
     */
    public function setChosenAccessTypes(\ArrayType\ArrayOfString $chosenAccessTypes = null)
    {
        $this->ChosenAccessTypes = $chosenAccessTypes;
        return $this;
    }
    /**
     * Get AdditionalServices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalServices()
    {
        return $this->AdditionalServices;
    }
    /**
     * Set AdditionalServices value
     * @param \ArrayType\ArrayOfString $additionalServices
     * @return \StructType\CircuitDetails
     */
    public function setAdditionalServices(\ArrayType\ArrayOfString $additionalServices = null)
    {
        $this->AdditionalServices = $additionalServices;
        return $this;
    }
    /**
     * Get CloudConnectOptions value
     * @return \ArrayType\ArrayOfCloudConnectRequest|null
     */
    public function getCloudConnectOptions()
    {
        return $this->CloudConnectOptions;
    }
    /**
     * Set CloudConnectOptions value
     * @param \ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions
     * @return \StructType\CircuitDetails
     */
    public function setCloudConnectOptions(\ArrayType\ArrayOfCloudConnectRequest $cloudConnectOptions = null)
    {
        $this->CloudConnectOptions = $cloudConnectOptions;
        return $this;
    }
}
