<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQuotationLine ArrayType
 * @subpackage Arrays
 */
class ArrayOfQuotationLine extends AbstractStructArrayBase
{
    /**
     * The QuotationLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QuotationLine[]
     */
    public $QuotationLine;
    /**
     * Constructor method for ArrayOfQuotationLine
     * @uses ArrayOfQuotationLine::setQuotationLine()
     * @param \StructType\QuotationLine[] $quotationLine
     */
    public function __construct(array $quotationLine = array())
    {
        $this
            ->setQuotationLine($quotationLine);
    }
    /**
     * Get QuotationLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QuotationLine[]|null
     */
    public function getQuotationLine()
    {
        return isset($this->QuotationLine) ? $this->QuotationLine : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQuotationLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuotationLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuotationLineForArrayConstraintsFromSetQuotationLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQuotationLineQuotationLineItem) {
            // validation for constraint: itemType
            if (!$arrayOfQuotationLineQuotationLineItem instanceof \StructType\QuotationLine) {
                $invalidValues[] = is_object($arrayOfQuotationLineQuotationLineItem) ? get_class($arrayOfQuotationLineQuotationLineItem) : sprintf('%s(%s)', gettype($arrayOfQuotationLineQuotationLineItem), var_export($arrayOfQuotationLineQuotationLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QuotationLine property can only contain items of type \StructType\QuotationLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QuotationLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QuotationLine[] $quotationLine
     * @return \ArrayType\ArrayOfQuotationLine
     */
    public function setQuotationLine(array $quotationLine = array())
    {
        // validation for constraint: array
        if ('' !== ($quotationLineArrayErrorMessage = self::validateQuotationLineForArrayConstraintsFromSetQuotationLine($quotationLine))) {
            throw new \InvalidArgumentException($quotationLineArrayErrorMessage, __LINE__);
        }
        if (is_null($quotationLine) || (is_array($quotationLine) && empty($quotationLine))) {
            unset($this->QuotationLine);
        } else {
            $this->QuotationLine = $quotationLine;
        }
        return $this;
    }
    /**
     * Add item to QuotationLine value
     * @throws \InvalidArgumentException
     * @param \StructType\QuotationLine $item
     * @return \ArrayType\ArrayOfQuotationLine
     */
    public function addToQuotationLine(\StructType\QuotationLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuotationLine) {
            throw new \InvalidArgumentException(sprintf('The QuotationLine property can only contain items of type \StructType\QuotationLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QuotationLine[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QuotationLine|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QuotationLine|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QuotationLine|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QuotationLine|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QuotationLine|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QuotationLine
     */
    public function getAttributeName()
    {
        return 'QuotationLine';
    }
}
