<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCloudConnectProvider ArrayType
 * @subpackage Arrays
 */
class ArrayOfCloudConnectProvider extends AbstractStructArrayBase
{
    /**
     * The CloudConnectProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CloudConnectProvider[]
     */
    public $CloudConnectProvider;
    /**
     * Constructor method for ArrayOfCloudConnectProvider
     * @uses ArrayOfCloudConnectProvider::setCloudConnectProvider()
     * @param \StructType\CloudConnectProvider[] $cloudConnectProvider
     */
    public function __construct(array $cloudConnectProvider = array())
    {
        $this
            ->setCloudConnectProvider($cloudConnectProvider);
    }
    /**
     * Get CloudConnectProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CloudConnectProvider[]|null
     */
    public function getCloudConnectProvider()
    {
        return isset($this->CloudConnectProvider) ? $this->CloudConnectProvider : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCloudConnectProvider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCloudConnectProvider method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCloudConnectProviderForArrayConstraintsFromSetCloudConnectProvider(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCloudConnectProviderCloudConnectProviderItem) {
            // validation for constraint: itemType
            if (!$arrayOfCloudConnectProviderCloudConnectProviderItem instanceof \StructType\CloudConnectProvider) {
                $invalidValues[] = is_object($arrayOfCloudConnectProviderCloudConnectProviderItem) ? get_class($arrayOfCloudConnectProviderCloudConnectProviderItem) : sprintf('%s(%s)', gettype($arrayOfCloudConnectProviderCloudConnectProviderItem), var_export($arrayOfCloudConnectProviderCloudConnectProviderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CloudConnectProvider property can only contain items of type \StructType\CloudConnectProvider, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CloudConnectProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CloudConnectProvider[] $cloudConnectProvider
     * @return \ArrayType\ArrayOfCloudConnectProvider
     */
    public function setCloudConnectProvider(array $cloudConnectProvider = array())
    {
        // validation for constraint: array
        if ('' !== ($cloudConnectProviderArrayErrorMessage = self::validateCloudConnectProviderForArrayConstraintsFromSetCloudConnectProvider($cloudConnectProvider))) {
            throw new \InvalidArgumentException($cloudConnectProviderArrayErrorMessage, __LINE__);
        }
        if (is_null($cloudConnectProvider) || (is_array($cloudConnectProvider) && empty($cloudConnectProvider))) {
            unset($this->CloudConnectProvider);
        } else {
            $this->CloudConnectProvider = $cloudConnectProvider;
        }
        return $this;
    }
    /**
     * Add item to CloudConnectProvider value
     * @throws \InvalidArgumentException
     * @param \StructType\CloudConnectProvider $item
     * @return \ArrayType\ArrayOfCloudConnectProvider
     */
    public function addToCloudConnectProvider(\StructType\CloudConnectProvider $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CloudConnectProvider) {
            throw new \InvalidArgumentException(sprintf('The CloudConnectProvider property can only contain items of type \StructType\CloudConnectProvider, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CloudConnectProvider[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CloudConnectProvider|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CloudConnectProvider|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CloudConnectProvider|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CloudConnectProvider|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CloudConnectProvider|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CloudConnectProvider
     */
    public function getAttributeName()
    {
        return 'CloudConnectProvider';
    }
}
