<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReverseGeoCoord StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReverseGeoCoord
 * @package Pcm
 * @subpackage Structs
 */
class PcmReverseGeoCoord extends PcmCoordinates
{
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The SpeedLimitOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmSpeedLimitOptions
     */
    public $SpeedLimitOption;
    /**
     * Constructor method for ReverseGeoCoord
     * @uses PcmReverseGeoCoord::setRegion()
     * @uses PcmReverseGeoCoord::setSpeedLimitOption()
     * @param string $region
     * @param \Pcm\StructType\PcmSpeedLimitOptions $speedLimitOption
     */
    public function __construct($region = null, \Pcm\StructType\PcmSpeedLimitOptions $speedLimitOption = null)
    {
        $this
            ->setRegion($region)
            ->setSpeedLimitOption($speedLimitOption);
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmReverseGeoCoord
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get SpeedLimitOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmSpeedLimitOptions|null
     */
    public function getSpeedLimitOption()
    {
        return isset($this->SpeedLimitOption) ? $this->SpeedLimitOption : null;
    }
    /**
     * Set SpeedLimitOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmSpeedLimitOptions $speedLimitOption
     * @return \Pcm\StructType\PcmReverseGeoCoord
     */
    public function setSpeedLimitOption(\Pcm\StructType\PcmSpeedLimitOptions $speedLimitOption = null)
    {
        if (is_null($speedLimitOption) || (is_array($speedLimitOption) && empty($speedLimitOption))) {
            unset($this->SpeedLimitOption);
        } else {
            $this->SpeedLimitOption = $speedLimitOption;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReverseGeoCoord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
