<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseHeader
 * @package Pcm
 * @subpackage Structs
 */
class PcmResponseHeader extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * The DataVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataVersion;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfError
     */
    public $Errors;
    /**
     * Constructor method for ResponseHeader
     * @uses PcmResponseHeader::setType()
     * @uses PcmResponseHeader::setSuccess()
     * @uses PcmResponseHeader::setDataVersion()
     * @uses PcmResponseHeader::setErrors()
     * @param string $type
     * @param bool $success
     * @param string $dataVersion
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     */
    public function __construct($type = null, $success = null, $dataVersion = null, \Pcm\ArrayType\PcmArrayOfError $errors = null)
    {
        $this
            ->setType($type)
            ->setSuccess($success)
            ->setDataVersion($dataVersion)
            ->setErrors($errors);
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \Pcm\StructType\PcmResponseHeader
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \Pcm\StructType\PcmResponseHeader
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get DataVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataVersion()
    {
        return isset($this->DataVersion) ? $this->DataVersion : null;
    }
    /**
     * Set DataVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataVersion
     * @return \Pcm\StructType\PcmResponseHeader
     */
    public function setDataVersion($dataVersion = null)
    {
        // validation for constraint: string
        if (!is_null($dataVersion) && !is_string($dataVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVersion)), __LINE__);
        }
        if (is_null($dataVersion) || (is_array($dataVersion) && empty($dataVersion))) {
            unset($this->DataVersion);
        } else {
            $this->DataVersion = $dataVersion;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     * @return \Pcm\StructType\PcmResponseHeader
     */
    public function setErrors(\Pcm\ArrayType\PcmArrayOfError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmResponseHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
