<?php

namespace Pcm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @package Pcm
 * @subpackage Services
 */
class PcmCreate extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pcm\StructType\PcmAuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\Pcm\StructType\PcmAuthHeader $authHeader, $nameSpace = 'http://pcmiler.alk.com/APIs/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateRouteSyncMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmCreateRouteSyncMessage $parameters
     * @return \Pcm\StructType\PcmCreateRouteSyncMessageResponse|bool
     */
    public function CreateRouteSyncMessage(\Pcm\StructType\PcmCreateRouteSyncMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateRouteSyncMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pcm\StructType\PcmCreateRouteSyncMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
