<?php

namespace Pcm\EnumType;

/**
 * This class stands for BackgroundImageProvider EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BackgroundImageProvider
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmBackgroundImageProvider
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Sat1'
     * @return string 'Sat1'
     */
    const VALUE_SAT_1 = 'Sat1';
    /**
     * Constant for value 'Sat2'
     * @return string 'Sat2'
     */
    const VALUE_SAT_2 = 'Sat2';
    /**
     * Constant for value 'Sat3'
     * @return string 'Sat3'
     */
    const VALUE_SAT_3 = 'Sat3';
    /**
     * Constant for value 'Sat4'
     * @return string 'Sat4'
     */
    const VALUE_SAT_4 = 'Sat4';
    /**
     * Constant for value 'Sat5'
     * @return string 'Sat5'
     */
    const VALUE_SAT_5 = 'Sat5';
    /**
     * Constant for value 'Sat6'
     * @return string 'Sat6'
     */
    const VALUE_SAT_6 = 'Sat6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_SAT_1
     * @uses self::VALUE_SAT_2
     * @uses self::VALUE_SAT_3
     * @uses self::VALUE_SAT_4
     * @uses self::VALUE_SAT_5
     * @uses self::VALUE_SAT_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_SAT_1,
            self::VALUE_SAT_2,
            self::VALUE_SAT_3,
            self::VALUE_SAT_4,
            self::VALUE_SAT_5,
            self::VALUE_SAT_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
