<?php

namespace Pcm\EnumType;

/**
 * This class stands for AFType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AFType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmAFType
{
    /**
     * Constant for value 'Avoid'
     * @return string 'Avoid'
     */
    const VALUE_AVOID = 'Avoid';
    /**
     * Constant for value 'Favor'
     * @return string 'Favor'
     */
    const VALUE_FAVOR = 'Favor';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVOID
     * @uses self::VALUE_FAVOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVOID,
            self::VALUE_FAVOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
