<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReportType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReportType
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfReportType extends AbstractStructArrayBase
{
    /**
     * The ReportType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmReportType[]
     */
    public $ReportType;
    /**
     * Constructor method for ArrayOfReportType
     * @uses PcmArrayOfReportType::setReportType()
     * @param \Pcm\StructType\PcmReportType[] $reportType
     */
    public function __construct(array $reportType = array())
    {
        $this
            ->setReportType($reportType);
    }
    /**
     * Get ReportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmReportType[]|null
     */
    public function getReportType()
    {
        return isset($this->ReportType) ? $this->ReportType : null;
    }
    /**
     * Set ReportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmReportType[] $reportType
     * @return \Pcm\ArrayType\PcmArrayOfReportType
     */
    public function setReportType(array $reportType = array())
    {
        foreach ($reportType as $arrayOfReportTypeReportTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfReportTypeReportTypeItem instanceof \Pcm\StructType\PcmReportType) {
                throw new \InvalidArgumentException(sprintf('The ReportType property can only contain items of \Pcm\StructType\PcmReportType, "%s" given', is_object($arrayOfReportTypeReportTypeItem) ? get_class($arrayOfReportTypeReportTypeItem) : gettype($arrayOfReportTypeReportTypeItem)), __LINE__);
            }
        }
        if (is_null($reportType) || (is_array($reportType) && empty($reportType))) {
            unset($this->ReportType);
        } else {
            $this->ReportType = $reportType;
        }
        return $this;
    }
    /**
     * Add item to ReportType value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmReportType $item
     * @return \Pcm\ArrayType\PcmArrayOfReportType
     */
    public function addToReportType(\Pcm\StructType\PcmReportType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmReportType) {
            throw new \InvalidArgumentException(sprintf('The ReportType property can only contain items of \Pcm\StructType\PcmReportType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReportType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReportType
     */
    public function getAttributeName()
    {
        return 'ReportType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfReportType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
