<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCoordinates ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCoordinates
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfCoordinates extends AbstractStructArrayBase
{
    /**
     * The Coordinates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates[]
     */
    public $Coordinates;
    /**
     * Constructor method for ArrayOfCoordinates
     * @uses PcmArrayOfCoordinates::setCoordinates()
     * @param \Pcm\StructType\PcmCoordinates[] $coordinates
     */
    public function __construct(array $coordinates = array())
    {
        $this
            ->setCoordinates($coordinates);
    }
    /**
     * Get Coordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates[]|null
     */
    public function getCoordinates()
    {
        return isset($this->Coordinates) ? $this->Coordinates : null;
    }
    /**
     * Set Coordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmCoordinates[] $coordinates
     * @return \Pcm\ArrayType\PcmArrayOfCoordinates
     */
    public function setCoordinates(array $coordinates = array())
    {
        foreach ($coordinates as $arrayOfCoordinatesCoordinatesItem) {
            // validation for constraint: itemType
            if (!$arrayOfCoordinatesCoordinatesItem instanceof \Pcm\StructType\PcmCoordinates) {
                throw new \InvalidArgumentException(sprintf('The Coordinates property can only contain items of \Pcm\StructType\PcmCoordinates, "%s" given', is_object($arrayOfCoordinatesCoordinatesItem) ? get_class($arrayOfCoordinatesCoordinatesItem) : gettype($arrayOfCoordinatesCoordinatesItem)), __LINE__);
            }
        }
        if (is_null($coordinates) || (is_array($coordinates) && empty($coordinates))) {
            unset($this->Coordinates);
        } else {
            $this->Coordinates = $coordinates;
        }
        return $this;
    }
    /**
     * Add item to Coordinates value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmCoordinates $item
     * @return \Pcm\ArrayType\PcmArrayOfCoordinates
     */
    public function addToCoordinates(\Pcm\StructType\PcmCoordinates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmCoordinates) {
            throw new \InvalidArgumentException(sprintf('The Coordinates property can only contain items of \Pcm\StructType\PcmCoordinates, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Coordinates[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Coordinates
     */
    public function getAttributeName()
    {
        return 'Coordinates';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfCoordinates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
