<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteMatrixInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteMatrixInfo
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteMatrixInfo extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfError
     */
    public $Errors;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Time;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Distance;
    /**
     * Constructor method for RouteMatrixInfo
     * @uses PcmRouteMatrixInfo::setSuccess()
     * @uses PcmRouteMatrixInfo::setErrors()
     * @uses PcmRouteMatrixInfo::setTime()
     * @uses PcmRouteMatrixInfo::setDistance()
     * @param bool $success
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     * @param string $time
     * @param string $distance
     */
    public function __construct($success = null, \Pcm\ArrayType\PcmArrayOfError $errors = null, $time = null, $distance = null)
    {
        $this
            ->setSuccess($success)
            ->setErrors($errors)
            ->setTime($time)
            ->setDistance($distance);
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \Pcm\StructType\PcmRouteMatrixInfo
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     * @return \Pcm\StructType\PcmRouteMatrixInfo
     */
    public function setErrors(\Pcm\ArrayType\PcmArrayOfError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTime()
    {
        return isset($this->Time) ? $this->Time : null;
    }
    /**
     * Set Time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $time
     * @return \Pcm\StructType\PcmRouteMatrixInfo
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        if (is_null($time) || (is_array($time) && empty($time))) {
            unset($this->Time);
        } else {
            $this->Time = $time;
        }
        return $this;
    }
    /**
     * Get Distance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistance()
    {
        return isset($this->Distance) ? $this->Distance : null;
    }
    /**
     * Set Distance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distance
     * @return \Pcm\StructType\PcmRouteMatrixInfo
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distance)), __LINE__);
        }
        if (is_null($distance) || (is_array($distance) && empty($distance))) {
            unset($this->Distance);
        } else {
            $this->Distance = $distance;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteMatrixInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
