<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSpeed StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadSpeed
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoadSpeed extends AbstractStructBase
{
    /**
     * The RoadCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoadCategory;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Speed;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for RoadSpeed
     * @uses PcmRoadSpeed::setRoadCategory()
     * @uses PcmRoadSpeed::setSpeed()
     * @uses PcmRoadSpeed::setState()
     * @param string $roadCategory
     * @param int $speed
     * @param string $state
     */
    public function __construct($roadCategory = null, $speed = null, $state = null)
    {
        $this
            ->setRoadCategory($roadCategory)
            ->setSpeed($speed)
            ->setState($state);
    }
    /**
     * Get RoadCategory value
     * @return string|null
     */
    public function getRoadCategory()
    {
        return $this->RoadCategory;
    }
    /**
     * Set RoadCategory value
     * @uses \Pcm\EnumType\PcmRoadType::valueIsValid()
     * @uses \Pcm\EnumType\PcmRoadType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadCategory
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setRoadCategory($roadCategory = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmRoadType::valueIsValid($roadCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadCategory, implode(', ', \Pcm\EnumType\PcmRoadType::getValidValues())), __LINE__);
        }
        $this->RoadCategory = $roadCategory;
        return $this;
    }
    /**
     * Get Speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
