<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Error
 * @package Pcm
 * @subpackage Structs
 */
class PcmError extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The LegacyErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LegacyErrorCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Error
     * @uses PcmError::setType()
     * @uses PcmError::setCode()
     * @uses PcmError::setLegacyErrorCode()
     * @uses PcmError::setDescription()
     * @param string $type
     * @param string $code
     * @param int $legacyErrorCode
     * @param string $description
     */
    public function __construct($type = null, $code = null, $legacyErrorCode = null, $description = null)
    {
        $this
            ->setType($type)
            ->setCode($code)
            ->setLegacyErrorCode($legacyErrorCode)
            ->setDescription($description);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmErrorType::valueIsValid()
     * @uses \Pcm\EnumType\PcmErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmError
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmErrorType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmErrorType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \Pcm\EnumType\PcmPcmwsExceptionCode::valueIsValid()
     * @uses \Pcm\EnumType\PcmPcmwsExceptionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \Pcm\StructType\PcmError
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPcmwsExceptionCode::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \Pcm\EnumType\PcmPcmwsExceptionCode::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LegacyErrorCode value
     * @return int|null
     */
    public function getLegacyErrorCode()
    {
        return $this->LegacyErrorCode;
    }
    /**
     * Set LegacyErrorCode value
     * @param int $legacyErrorCode
     * @return \Pcm\StructType\PcmError
     */
    public function setLegacyErrorCode($legacyErrorCode = null)
    {
        // validation for constraint: int
        if (!is_null($legacyErrorCode) && !is_numeric($legacyErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($legacyErrorCode)), __LINE__);
        }
        $this->LegacyErrorCode = $legacyErrorCode;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Pcm\StructType\PcmError
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
