<?php

namespace Pcm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @package Pcm
 * @subpackage Services
 */
class PcmSet extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pcm\StructType\PcmAuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\Pcm\StructType\PcmAuthHeader $authHeader, $nameSpace = 'http://pcmiler.alk.com/APIs/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetAvoidFavor
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmSetAvoidFavor $parameters
     * @return \Pcm\StructType\PcmSetAvoidFavorResponse|bool
     */
    public function SetAvoidFavor(\Pcm\StructType\PcmSetAvoidFavor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAvoidFavor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomPlaces
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmSetCustomPlaces $parameters
     * @return \Pcm\StructType\PcmSetCustomPlacesResponse|bool
     */
    public function SetCustomPlaces(\Pcm\StructType\PcmSetCustomPlaces $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCustomPlaces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetRoadSpeeds
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmSetRoadSpeeds $parameters
     * @return \Pcm\StructType\PcmSetRoadSpeedsResponse|bool
     */
    public function SetRoadSpeeds(\Pcm\StructType\PcmSetRoadSpeeds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetRoadSpeeds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pcm\StructType\PcmSetAvoidFavorResponse|\Pcm\StructType\PcmSetCustomPlacesResponse|\Pcm\StructType\PcmSetRoadSpeedsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
