<?php

namespace Pcm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @package Pcm
 * @subpackage Services
 */
class PcmProcess extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pcm\StructType\PcmAuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\Pcm\StructType\PcmAuthHeader $authHeader, $nameSpace = 'http://pcmiler.alk.com/APIs/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessGeocode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmProcessGeocode $parameters
     * @return \Pcm\StructType\PcmProcessGeocodeResponse|bool
     */
    public function ProcessGeocode(\Pcm\StructType\PcmProcessGeocode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessGeocode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessReverseGeocode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmProcessReverseGeocode $parameters
     * @return \Pcm\StructType\PcmProcessReverseGeocodeResponse|bool
     */
    public function ProcessReverseGeocode(\Pcm\StructType\PcmProcessReverseGeocode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessReverseGeocode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessRadiusSearch
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmProcessRadiusSearch $parameters
     * @return \Pcm\StructType\PcmProcessRadiusSearchResponse|bool
     */
    public function ProcessRadiusSearch(\Pcm\StructType\PcmProcessRadiusSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessRadiusSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessStates
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmProcessStates $parameters
     * @return \Pcm\StructType\PcmProcessStatesResponse|bool
     */
    public function ProcessStates(\Pcm\StructType\PcmProcessStates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessStates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessMap
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : AuthHeader
     * - SOAPHeaderNamespaces : http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes : \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmProcessMap $parameters
     * @return \Pcm\StructType\PcmProcessMapResponse|bool
     */
    public function ProcessMap(\Pcm\StructType\PcmProcessMap $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessMap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pcm\StructType\PcmProcessGeocodeResponse|\Pcm\StructType\PcmProcessMapResponse|\Pcm\StructType\PcmProcessRadiusSearchResponse|\Pcm\StructType\PcmProcessReverseGeocodeResponse|\Pcm\StructType\PcmProcessStatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
