<?php

namespace Pcm\EnumType;

/**
 * This class stands for TrafficType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrafficType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmTrafficType
{
    /**
     * Constant for value 'Congestion'
     * @return string 'Congestion'
     */
    const VALUE_CONGESTION = 'Congestion';
    /**
     * Constant for value 'RoadSpeed'
     * @return string 'RoadSpeed'
     */
    const VALUE_ROAD_SPEED = 'RoadSpeed';
    /**
     * Constant for value 'Neither'
     * @return string 'Neither'
     */
    const VALUE_NEITHER = 'Neither';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONGESTION
     * @uses self::VALUE_ROAD_SPEED
     * @uses self::VALUE_NEITHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONGESTION,
            self::VALUE_ROAD_SPEED,
            self::VALUE_NEITHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
