<?php

namespace Pcm\EnumType;

/**
 * This class stands for POIType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:POIType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPOIType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'Zip'
     * @return string 'Zip'
     */
    const VALUE_ZIP = 'Zip';
    /**
     * Constant for value 'Place'
     * @return string 'Place'
     */
    const VALUE_PLACE = 'Place';
    /**
     * Constant for value 'Airport'
     * @return string 'Airport'
     */
    const VALUE_AIRPORT = 'Airport';
    /**
     * Constant for value 'Automotive'
     * @return string 'Automotive'
     */
    const VALUE_AUTOMOTIVE = 'Automotive';
    /**
     * Constant for value 'WeighStation'
     * @return string 'WeighStation'
     */
    const VALUE_WEIGH_STATION = 'WeighStation';
    /**
     * Constant for value 'Dining'
     * @return string 'Dining'
     */
    const VALUE_DINING = 'Dining';
    /**
     * Constant for value 'Education'
     * @return string 'Education'
     */
    const VALUE_EDUCATION = 'Education';
    /**
     * Constant for value 'Emergency'
     * @return string 'Emergency'
     */
    const VALUE_EMERGENCY = 'Emergency';
    /**
     * Constant for value 'Government'
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Gas'
     * @return string 'Gas'
     */
    const VALUE_GAS = 'Gas';
    /**
     * Constant for value 'Lodging'
     * @return string 'Lodging'
     */
    const VALUE_LODGING = 'Lodging';
    /**
     * Constant for value 'Parks'
     * @return string 'Parks'
     */
    const VALUE_PARKS = 'Parks';
    /**
     * Constant for value 'Retail'
     * @return string 'Retail'
     */
    const VALUE_RETAIL = 'Retail';
    /**
     * Constant for value 'RVServices'
     * @return string 'RVServices'
     */
    const VALUE_RVSERVICES = 'RVServices';
    /**
     * Constant for value 'SportsRec'
     * @return string 'SportsRec'
     */
    const VALUE_SPORTS_REC = 'SportsRec';
    /**
     * Constant for value 'Travel'
     * @return string 'Travel'
     */
    const VALUE_TRAVEL = 'Travel';
    /**
     * Constant for value 'TruckServices'
     * @return string 'TruckServices'
     */
    const VALUE_TRUCK_SERVICES = 'TruckServices';
    /**
     * Constant for value 'Attractions'
     * @return string 'Attractions'
     */
    const VALUE_ATTRACTIONS = 'Attractions';
    /**
     * Constant for value 'OilAndGas'
     * @return string 'OilAndGas'
     */
    const VALUE_OIL_AND_GAS = 'OilAndGas';
    /**
     * Constant for value 'AutoDealership'
     * @return string 'AutoDealership'
     */
    const VALUE_AUTO_DEALERSHIP = 'AutoDealership';
    /**
     * Constant for value 'Bank'
     * @return string 'Bank'
     */
    const VALUE_BANK = 'Bank';
    /**
     * Constant for value 'BridgesAndTunnels'
     * @return string 'BridgesAndTunnels'
     */
    const VALUE_BRIDGES_AND_TUNNELS = 'BridgesAndTunnels';
    /**
     * Constant for value 'BusTaxiLimo'
     * @return string 'BusTaxiLimo'
     */
    const VALUE_BUS_TAXI_LIMO = 'BusTaxiLimo';
    /**
     * Constant for value 'CATScales'
     * @return string 'CATScales'
     */
    const VALUE_CATSCALES = 'CATScales';
    /**
     * Constant for value 'CityHall'
     * @return string 'CityHall'
     */
    const VALUE_CITY_HALL = 'CityHall';
    /**
     * Constant for value 'DieselExhaustFluid'
     * @return string 'DieselExhaustFluid'
     */
    const VALUE_DIESEL_EXHAUST_FLUID = 'DieselExhaustFluid';
    /**
     * Constant for value 'Entertainment'
     * @return string 'Entertainment'
     */
    const VALUE_ENTERTAINMENT = 'Entertainment';
    /**
     * Constant for value 'EventFacility'
     * @return string 'EventFacility'
     */
    const VALUE_EVENT_FACILITY = 'EventFacility';
    /**
     * Constant for value 'FerryTerminal'
     * @return string 'FerryTerminal'
     */
    const VALUE_FERRY_TERMINAL = 'FerryTerminal';
    /**
     * Constant for value 'GeographicFeature'
     * @return string 'GeographicFeature'
     */
    const VALUE_GEOGRAPHIC_FEATURE = 'GeographicFeature';
    /**
     * Constant for value 'GroceryStore'
     * @return string 'GroceryStore'
     */
    const VALUE_GROCERY_STORE = 'GroceryStore';
    /**
     * Constant for value 'GuestHouse'
     * @return string 'GuestHouse'
     */
    const VALUE_GUEST_HOUSE = 'GuestHouse';
    /**
     * Constant for value 'HighwayExit'
     * @return string 'HighwayExit'
     */
    const VALUE_HIGHWAY_EXIT = 'HighwayExit';
    /**
     * Constant for value 'IntermodalRampLarge'
     * @return string 'IntermodalRampLarge'
     */
    const VALUE_INTERMODAL_RAMP_LARGE = 'IntermodalRampLarge';
    /**
     * Constant for value 'IntermodalRampMedium'
     * @return string 'IntermodalRampMedium'
     */
    const VALUE_INTERMODAL_RAMP_MEDIUM = 'IntermodalRampMedium';
    /**
     * Constant for value 'IntermodalRampSmall'
     * @return string 'IntermodalRampSmall'
     */
    const VALUE_INTERMODAL_RAMP_SMALL = 'IntermodalRampSmall';
    /**
     * Constant for value 'LCVLot'
     * @return string 'LCVLot'
     */
    const VALUE_LCVLOT = 'LCVLot';
    /**
     * Constant for value 'Marina'
     * @return string 'Marina'
     */
    const VALUE_MARINA = 'Marina';
    /**
     * Constant for value 'Municipal'
     * @return string 'Municipal'
     */
    const VALUE_MUNICIPAL = 'Municipal';
    /**
     * Constant for value 'HighwayIntersection'
     * @return string 'HighwayIntersection'
     */
    const VALUE_HIGHWAY_INTERSECTION = 'HighwayIntersection';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Parking'
     * @return string 'Parking'
     */
    const VALUE_PARKING = 'Parking';
    /**
     * Constant for value 'PlaceOfWorship'
     * @return string 'PlaceOfWorship'
     */
    const VALUE_PLACE_OF_WORSHIP = 'PlaceOfWorship';
    /**
     * Constant for value 'PoliceStation'
     * @return string 'PoliceStation'
     */
    const VALUE_POLICE_STATION = 'PoliceStation';
    /**
     * Constant for value 'RailwayStation'
     * @return string 'RailwayStation'
     */
    const VALUE_RAILWAY_STATION = 'RailwayStation';
    /**
     * Constant for value 'RentACar'
     * @return string 'RentACar'
     */
    const VALUE_RENT_ACAR = 'RentACar';
    /**
     * Constant for value 'RestArea'
     * @return string 'RestArea'
     */
    const VALUE_REST_AREA = 'RestArea';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_CITY
     * @uses self::VALUE_ZIP
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_AUTOMOTIVE
     * @uses self::VALUE_WEIGH_STATION
     * @uses self::VALUE_DINING
     * @uses self::VALUE_EDUCATION
     * @uses self::VALUE_EMERGENCY
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_GAS
     * @uses self::VALUE_LODGING
     * @uses self::VALUE_PARKS
     * @uses self::VALUE_RETAIL
     * @uses self::VALUE_RVSERVICES
     * @uses self::VALUE_SPORTS_REC
     * @uses self::VALUE_TRAVEL
     * @uses self::VALUE_TRUCK_SERVICES
     * @uses self::VALUE_ATTRACTIONS
     * @uses self::VALUE_OIL_AND_GAS
     * @uses self::VALUE_AUTO_DEALERSHIP
     * @uses self::VALUE_BANK
     * @uses self::VALUE_BRIDGES_AND_TUNNELS
     * @uses self::VALUE_BUS_TAXI_LIMO
     * @uses self::VALUE_CATSCALES
     * @uses self::VALUE_CITY_HALL
     * @uses self::VALUE_DIESEL_EXHAUST_FLUID
     * @uses self::VALUE_ENTERTAINMENT
     * @uses self::VALUE_EVENT_FACILITY
     * @uses self::VALUE_FERRY_TERMINAL
     * @uses self::VALUE_GEOGRAPHIC_FEATURE
     * @uses self::VALUE_GROCERY_STORE
     * @uses self::VALUE_GUEST_HOUSE
     * @uses self::VALUE_HIGHWAY_EXIT
     * @uses self::VALUE_INTERMODAL_RAMP_LARGE
     * @uses self::VALUE_INTERMODAL_RAMP_MEDIUM
     * @uses self::VALUE_INTERMODAL_RAMP_SMALL
     * @uses self::VALUE_LCVLOT
     * @uses self::VALUE_MARINA
     * @uses self::VALUE_MUNICIPAL
     * @uses self::VALUE_HIGHWAY_INTERSECTION
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_PARKING
     * @uses self::VALUE_PLACE_OF_WORSHIP
     * @uses self::VALUE_POLICE_STATION
     * @uses self::VALUE_RAILWAY_STATION
     * @uses self::VALUE_RENT_ACAR
     * @uses self::VALUE_REST_AREA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_CITY,
            self::VALUE_ZIP,
            self::VALUE_PLACE,
            self::VALUE_AIRPORT,
            self::VALUE_AUTOMOTIVE,
            self::VALUE_WEIGH_STATION,
            self::VALUE_DINING,
            self::VALUE_EDUCATION,
            self::VALUE_EMERGENCY,
            self::VALUE_GOVERNMENT,
            self::VALUE_GAS,
            self::VALUE_LODGING,
            self::VALUE_PARKS,
            self::VALUE_RETAIL,
            self::VALUE_RVSERVICES,
            self::VALUE_SPORTS_REC,
            self::VALUE_TRAVEL,
            self::VALUE_TRUCK_SERVICES,
            self::VALUE_ATTRACTIONS,
            self::VALUE_OIL_AND_GAS,
            self::VALUE_AUTO_DEALERSHIP,
            self::VALUE_BANK,
            self::VALUE_BRIDGES_AND_TUNNELS,
            self::VALUE_BUS_TAXI_LIMO,
            self::VALUE_CATSCALES,
            self::VALUE_CITY_HALL,
            self::VALUE_DIESEL_EXHAUST_FLUID,
            self::VALUE_ENTERTAINMENT,
            self::VALUE_EVENT_FACILITY,
            self::VALUE_FERRY_TERMINAL,
            self::VALUE_GEOGRAPHIC_FEATURE,
            self::VALUE_GROCERY_STORE,
            self::VALUE_GUEST_HOUSE,
            self::VALUE_HIGHWAY_EXIT,
            self::VALUE_INTERMODAL_RAMP_LARGE,
            self::VALUE_INTERMODAL_RAMP_MEDIUM,
            self::VALUE_INTERMODAL_RAMP_SMALL,
            self::VALUE_LCVLOT,
            self::VALUE_MARINA,
            self::VALUE_MUNICIPAL,
            self::VALUE_HIGHWAY_INTERSECTION,
            self::VALUE_OTHER,
            self::VALUE_PARKING,
            self::VALUE_PLACE_OF_WORSHIP,
            self::VALUE_POLICE_STATION,
            self::VALUE_RAILWAY_STATION,
            self::VALUE_RENT_ACAR,
            self::VALUE_REST_AREA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
