<?php

namespace Pcm\EnumType;

/**
 * This class stands for POIGenericType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:POIGenericType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPOIGenericType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'WeightStation'
     * @return string 'WeightStation'
     */
    const VALUE_WEIGHT_STATION = 'WeightStation';
    /**
     * Constant for value 'CatScale'
     * @return string 'CatScale'
     */
    const VALUE_CAT_SCALE = 'CatScale';
    /**
     * Constant for value 'LCVLot'
     * @return string 'LCVLot'
     */
    const VALUE_LCVLOT = 'LCVLot';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'IntermodalSmall'
     * @return string 'IntermodalSmall'
     */
    const VALUE_INTERMODAL_SMALL = 'IntermodalSmall';
    /**
     * Constant for value 'IntermodalMedium'
     * @return string 'IntermodalMedium'
     */
    const VALUE_INTERMODAL_MEDIUM = 'IntermodalMedium';
    /**
     * Constant for value 'IntermodalLarge'
     * @return string 'IntermodalLarge'
     */
    const VALUE_INTERMODAL_LARGE = 'IntermodalLarge';
    /**
     * Constant for value 'Parking'
     * @return string 'Parking'
     */
    const VALUE_PARKING = 'Parking';
    /**
     * Constant for value 'RestAreaHoS'
     * @return string 'RestAreaHoS'
     */
    const VALUE_REST_AREA_HO_S = 'RestAreaHoS';
    /**
     * Constant for value 'TruckStop'
     * @return string 'TruckStop'
     */
    const VALUE_TRUCK_STOP = 'TruckStop';
    /**
     * Constant for value 'TruckServiceHoS'
     * @return string 'TruckServiceHoS'
     */
    const VALUE_TRUCK_SERVICE_HO_S = 'TruckServiceHoS';
    /**
     * Constant for value 'HighwayExit'
     * @return string 'HighwayExit'
     */
    const VALUE_HIGHWAY_EXIT = 'HighwayExit';
    /**
     * Constant for value 'MajorAirport'
     * @return string 'MajorAirport'
     */
    const VALUE_MAJOR_AIRPORT = 'MajorAirport';
    /**
     * Constant for value 'EventFacility'
     * @return string 'EventFacility'
     */
    const VALUE_EVENT_FACILITY = 'EventFacility';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_WEIGHT_STATION
     * @uses self::VALUE_CAT_SCALE
     * @uses self::VALUE_LCVLOT
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_INTERMODAL_SMALL
     * @uses self::VALUE_INTERMODAL_MEDIUM
     * @uses self::VALUE_INTERMODAL_LARGE
     * @uses self::VALUE_PARKING
     * @uses self::VALUE_REST_AREA_HO_S
     * @uses self::VALUE_TRUCK_STOP
     * @uses self::VALUE_TRUCK_SERVICE_HO_S
     * @uses self::VALUE_HIGHWAY_EXIT
     * @uses self::VALUE_MAJOR_AIRPORT
     * @uses self::VALUE_EVENT_FACILITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_WEIGHT_STATION,
            self::VALUE_CAT_SCALE,
            self::VALUE_LCVLOT,
            self::VALUE_HOTEL,
            self::VALUE_INTERMODAL_SMALL,
            self::VALUE_INTERMODAL_MEDIUM,
            self::VALUE_INTERMODAL_LARGE,
            self::VALUE_PARKING,
            self::VALUE_REST_AREA_HO_S,
            self::VALUE_TRUCK_STOP,
            self::VALUE_TRUCK_SERVICE_HO_S,
            self::VALUE_HIGHWAY_EXIT,
            self::VALUE_MAJOR_AIRPORT,
            self::VALUE_EVENT_FACILITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
