<?php

namespace Pcm\EnumType;

/**
 * This class stands for MapStyle EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapStyle
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmMapStyle
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Classic'
     * @return string 'Classic'
     */
    const VALUE_CLASSIC = 'Classic';
    /**
     * Constant for value 'Monochrome'
     * @return string 'Monochrome'
     */
    const VALUE_MONOCHROME = 'Monochrome';
    /**
     * Constant for value 'RoadAtlas'
     * @return string 'RoadAtlas'
     */
    const VALUE_ROAD_ATLAS = 'RoadAtlas';
    /**
     * Constant for value 'Darkness'
     * @return string 'Darkness'
     */
    const VALUE_DARKNESS = 'Darkness';
    /**
     * Constant for value 'Modern'
     * @return string 'Modern'
     */
    const VALUE_MODERN = 'Modern';
    /**
     * Constant for value 'Contemporary'
     * @return string 'Contemporary'
     */
    const VALUE_CONTEMPORARY = 'Contemporary';
    /**
     * Constant for value 'Night'
     * @return string 'Night'
     */
    const VALUE_NIGHT = 'Night';
    /**
     * Constant for value 'Satellite'
     * @return string 'Satellite'
     */
    const VALUE_SATELLITE = 'Satellite';
    /**
     * Constant for value 'Lightness'
     * @return string 'Lightness'
     */
    const VALUE_LIGHTNESS = 'Lightness';
    /**
     * Constant for value 'Smooth'
     * @return string 'Smooth'
     */
    const VALUE_SMOOTH = 'Smooth';
    /**
     * Constant for value 'Terrain'
     * @return string 'Terrain'
     */
    const VALUE_TERRAIN = 'Terrain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_CLASSIC
     * @uses self::VALUE_MONOCHROME
     * @uses self::VALUE_ROAD_ATLAS
     * @uses self::VALUE_DARKNESS
     * @uses self::VALUE_MODERN
     * @uses self::VALUE_CONTEMPORARY
     * @uses self::VALUE_NIGHT
     * @uses self::VALUE_SATELLITE
     * @uses self::VALUE_LIGHTNESS
     * @uses self::VALUE_SMOOTH
     * @uses self::VALUE_TERRAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_CLASSIC,
            self::VALUE_MONOCHROME,
            self::VALUE_ROAD_ATLAS,
            self::VALUE_DARKNESS,
            self::VALUE_MODERN,
            self::VALUE_CONTEMPORARY,
            self::VALUE_NIGHT,
            self::VALUE_SATELLITE,
            self::VALUE_LIGHTNESS,
            self::VALUE_SMOOTH,
            self::VALUE_TERRAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
