<?php

namespace Pcm\EnumType;

/**
 * This class stands for DateOption EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DateOption
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmDateOption
{
    /**
     * Constant for value 'Current'
     * @return string 'Current'
     */
    const VALUE_CURRENT = 'Current';
    /**
     * Constant for value 'Specific'
     * @return string 'Specific'
     */
    const VALUE_SPECIFIC = 'Specific';
    /**
     * Constant for value 'DayOfWeek'
     * @return string 'DayOfWeek'
     */
    const VALUE_DAY_OF_WEEK = 'DayOfWeek';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_SPECIFIC
     * @uses self::VALUE_DAY_OF_WEEK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CURRENT,
            self::VALUE_SPECIFIC,
            self::VALUE_DAY_OF_WEEK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
