<?php

namespace Pcm\EnumType;

/**
 * This class stands for Currency EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Currency
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmCurrency
{
    /**
     * Constant for value 'US'
     * @return string 'US'
     */
    const VALUE_US = 'US';
    /**
     * Constant for value 'CDN'
     * @return string 'CDN'
     */
    const VALUE_CDN = 'CDN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_US
     * @uses self::VALUE_CDN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_US,
            self::VALUE_CDN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
