<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStopLocation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStopLocation
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfStopLocation extends AbstractStructArrayBase
{
    /**
     * The StopLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmStopLocation[]
     */
    public $StopLocation;
    /**
     * Constructor method for ArrayOfStopLocation
     * @uses PcmArrayOfStopLocation::setStopLocation()
     * @param \Pcm\StructType\PcmStopLocation[] $stopLocation
     */
    public function __construct(array $stopLocation = array())
    {
        $this
            ->setStopLocation($stopLocation);
    }
    /**
     * Get StopLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmStopLocation[]|null
     */
    public function getStopLocation()
    {
        return isset($this->StopLocation) ? $this->StopLocation : null;
    }
    /**
     * Set StopLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStopLocation[] $stopLocation
     * @return \Pcm\ArrayType\PcmArrayOfStopLocation
     */
    public function setStopLocation(array $stopLocation = array())
    {
        foreach ($stopLocation as $arrayOfStopLocationStopLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfStopLocationStopLocationItem instanceof \Pcm\StructType\PcmStopLocation) {
                throw new \InvalidArgumentException(sprintf('The StopLocation property can only contain items of \Pcm\StructType\PcmStopLocation, "%s" given', is_object($arrayOfStopLocationStopLocationItem) ? get_class($arrayOfStopLocationStopLocationItem) : gettype($arrayOfStopLocationStopLocationItem)), __LINE__);
            }
        }
        if (is_null($stopLocation) || (is_array($stopLocation) && empty($stopLocation))) {
            unset($this->StopLocation);
        } else {
            $this->StopLocation = $stopLocation;
        }
        return $this;
    }
    /**
     * Add item to StopLocation value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStopLocation $item
     * @return \Pcm\ArrayType\PcmArrayOfStopLocation
     */
    public function addToStopLocation(\Pcm\StructType\PcmStopLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmStopLocation) {
            throw new \InvalidArgumentException(sprintf('The StopLocation property can only contain items of \Pcm\StructType\PcmStopLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StopLocation
     */
    public function getAttributeName()
    {
        return 'StopLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfStopLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
