<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRouteMatrixInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRouteMatrixInfo
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfRouteMatrixInfo extends AbstractStructArrayBase
{
    /**
     * The RouteMatrixInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteMatrixInfo[]
     */
    public $RouteMatrixInfo;
    /**
     * Constructor method for ArrayOfRouteMatrixInfo
     * @uses PcmArrayOfRouteMatrixInfo::setRouteMatrixInfo()
     * @param \Pcm\StructType\PcmRouteMatrixInfo[] $routeMatrixInfo
     */
    public function __construct(array $routeMatrixInfo = array())
    {
        $this
            ->setRouteMatrixInfo($routeMatrixInfo);
    }
    /**
     * Get RouteMatrixInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteMatrixInfo[]|null
     */
    public function getRouteMatrixInfo()
    {
        return isset($this->RouteMatrixInfo) ? $this->RouteMatrixInfo : null;
    }
    /**
     * Set RouteMatrixInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRouteMatrixInfo[] $routeMatrixInfo
     * @return \Pcm\ArrayType\PcmArrayOfRouteMatrixInfo
     */
    public function setRouteMatrixInfo(array $routeMatrixInfo = array())
    {
        foreach ($routeMatrixInfo as $arrayOfRouteMatrixInfoRouteMatrixInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfRouteMatrixInfoRouteMatrixInfoItem instanceof \Pcm\StructType\PcmRouteMatrixInfo) {
                throw new \InvalidArgumentException(sprintf('The RouteMatrixInfo property can only contain items of \Pcm\StructType\PcmRouteMatrixInfo, "%s" given', is_object($arrayOfRouteMatrixInfoRouteMatrixInfoItem) ? get_class($arrayOfRouteMatrixInfoRouteMatrixInfoItem) : gettype($arrayOfRouteMatrixInfoRouteMatrixInfoItem)), __LINE__);
            }
        }
        if (is_null($routeMatrixInfo) || (is_array($routeMatrixInfo) && empty($routeMatrixInfo))) {
            unset($this->RouteMatrixInfo);
        } else {
            $this->RouteMatrixInfo = $routeMatrixInfo;
        }
        return $this;
    }
    /**
     * Add item to RouteMatrixInfo value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRouteMatrixInfo $item
     * @return \Pcm\ArrayType\PcmArrayOfRouteMatrixInfo
     */
    public function addToRouteMatrixInfo(\Pcm\StructType\PcmRouteMatrixInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmRouteMatrixInfo) {
            throw new \InvalidArgumentException(sprintf('The RouteMatrixInfo property can only contain items of \Pcm\StructType\PcmRouteMatrixInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RouteMatrixInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmRouteMatrixInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmRouteMatrixInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmRouteMatrixInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmRouteMatrixInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmRouteMatrixInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RouteMatrixInfo
     */
    public function getAttributeName()
    {
        return 'RouteMatrixInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfRouteMatrixInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
