<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDay StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeOfDay
 * @package Pcm
 * @subpackage Structs
 */
class PcmTimeOfDay extends AbstractStructBase
{
    /**
     * The Hour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Hour;
    /**
     * The Minute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Minute;
    /**
     * The AmPm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmPm;
    /**
     * Constructor method for TimeOfDay
     * @uses PcmTimeOfDay::setHour()
     * @uses PcmTimeOfDay::setMinute()
     * @uses PcmTimeOfDay::setAmPm()
     * @param int $hour
     * @param int $minute
     * @param string $amPm
     */
    public function __construct($hour = null, $minute = null, $amPm = null)
    {
        $this
            ->setHour($hour)
            ->setMinute($minute)
            ->setAmPm($amPm);
    }
    /**
     * Get Hour value
     * @return int|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param int $hour
     * @return \Pcm\StructType\PcmTimeOfDay
     */
    public function setHour($hour = null)
    {
        // validation for constraint: int
        if (!is_null($hour) && !is_numeric($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Minute value
     * @return int|null
     */
    public function getMinute()
    {
        return $this->Minute;
    }
    /**
     * Set Minute value
     * @param int $minute
     * @return \Pcm\StructType\PcmTimeOfDay
     */
    public function setMinute($minute = null)
    {
        // validation for constraint: int
        if (!is_null($minute) && !is_numeric($minute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minute)), __LINE__);
        }
        $this->Minute = $minute;
        return $this;
    }
    /**
     * Get AmPm value
     * @return string|null
     */
    public function getAmPm()
    {
        return $this->AmPm;
    }
    /**
     * Set AmPm value
     * @uses \Pcm\EnumType\PcmAmPmType::valueIsValid()
     * @uses \Pcm\EnumType\PcmAmPmType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amPm
     * @return \Pcm\StructType\PcmTimeOfDay
     */
    public function setAmPm($amPm = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmAmPmType::valueIsValid($amPm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $amPm, implode(', ', \Pcm\EnumType\PcmAmPmType::getValidValues())), __LINE__);
        }
        $this->AmPm = $amPm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTimeOfDay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
