<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeCosts StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeCosts
 * @package Pcm
 * @subpackage Structs
 */
class PcmTimeCosts extends AbstractStructBase
{
    /**
     * The BreakInterval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BreakInterval;
    /**
     * The BreakLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BreakLength;
    /**
     * The BorderWait
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BorderWait;
    /**
     * The DepartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmTimeOfDay
     */
    public $DepartTime;
    /**
     * The RemainingHoursOfService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RemainingHoursOfService;
    /**
     * Constructor method for TimeCosts
     * @uses PcmTimeCosts::setBreakInterval()
     * @uses PcmTimeCosts::setBreakLength()
     * @uses PcmTimeCosts::setBorderWait()
     * @uses PcmTimeCosts::setDepartTime()
     * @uses PcmTimeCosts::setRemainingHoursOfService()
     * @param float $breakInterval
     * @param float $breakLength
     * @param float $borderWait
     * @param \Pcm\StructType\PcmTimeOfDay $departTime
     * @param float $remainingHoursOfService
     */
    public function __construct($breakInterval = null, $breakLength = null, $borderWait = null, \Pcm\StructType\PcmTimeOfDay $departTime = null, $remainingHoursOfService = null)
    {
        $this
            ->setBreakInterval($breakInterval)
            ->setBreakLength($breakLength)
            ->setBorderWait($borderWait)
            ->setDepartTime($departTime)
            ->setRemainingHoursOfService($remainingHoursOfService);
    }
    /**
     * Get BreakInterval value
     * @return float|null
     */
    public function getBreakInterval()
    {
        return $this->BreakInterval;
    }
    /**
     * Set BreakInterval value
     * @param float $breakInterval
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public function setBreakInterval($breakInterval = null)
    {
        $this->BreakInterval = $breakInterval;
        return $this;
    }
    /**
     * Get BreakLength value
     * @return float|null
     */
    public function getBreakLength()
    {
        return $this->BreakLength;
    }
    /**
     * Set BreakLength value
     * @param float $breakLength
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public function setBreakLength($breakLength = null)
    {
        $this->BreakLength = $breakLength;
        return $this;
    }
    /**
     * Get BorderWait value
     * @return float|null
     */
    public function getBorderWait()
    {
        return $this->BorderWait;
    }
    /**
     * Set BorderWait value
     * @param float $borderWait
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public function setBorderWait($borderWait = null)
    {
        $this->BorderWait = $borderWait;
        return $this;
    }
    /**
     * Get DepartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmTimeOfDay|null
     */
    public function getDepartTime()
    {
        return isset($this->DepartTime) ? $this->DepartTime : null;
    }
    /**
     * Set DepartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmTimeOfDay $departTime
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public function setDepartTime(\Pcm\StructType\PcmTimeOfDay $departTime = null)
    {
        if (is_null($departTime) || (is_array($departTime) && empty($departTime))) {
            unset($this->DepartTime);
        } else {
            $this->DepartTime = $departTime;
        }
        return $this;
    }
    /**
     * Get RemainingHoursOfService value
     * @return float|null
     */
    public function getRemainingHoursOfService()
    {
        return $this->RemainingHoursOfService;
    }
    /**
     * Set RemainingHoursOfService value
     * @param float $remainingHoursOfService
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public function setRemainingHoursOfService($remainingHoursOfService = null)
    {
        $this->RemainingHoursOfService = $remainingHoursOfService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTimeCosts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
