<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SharedOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SharedOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmSharedOptions extends AbstractStructBase
{
    /**
     * The EstimatedTimeOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmEstimatedTimeOptions
     */
    public $EstimatedTimeOptions;
    /**
     * The TruckStyle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TruckStyle;
    /**
     * The UseTraffic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseTraffic;
    /**
     * Constructor method for SharedOptions
     * @uses PcmSharedOptions::setEstimatedTimeOptions()
     * @uses PcmSharedOptions::setTruckStyle()
     * @uses PcmSharedOptions::setUseTraffic()
     * @param \Pcm\StructType\PcmEstimatedTimeOptions $estimatedTimeOptions
     * @param string $truckStyle
     * @param bool $useTraffic
     */
    public function __construct(\Pcm\StructType\PcmEstimatedTimeOptions $estimatedTimeOptions = null, $truckStyle = null, $useTraffic = null)
    {
        $this
            ->setEstimatedTimeOptions($estimatedTimeOptions)
            ->setTruckStyle($truckStyle)
            ->setUseTraffic($useTraffic);
    }
    /**
     * Get EstimatedTimeOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmEstimatedTimeOptions|null
     */
    public function getEstimatedTimeOptions()
    {
        return isset($this->EstimatedTimeOptions) ? $this->EstimatedTimeOptions : null;
    }
    /**
     * Set EstimatedTimeOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmEstimatedTimeOptions $estimatedTimeOptions
     * @return \Pcm\StructType\PcmSharedOptions
     */
    public function setEstimatedTimeOptions(\Pcm\StructType\PcmEstimatedTimeOptions $estimatedTimeOptions = null)
    {
        if (is_null($estimatedTimeOptions) || (is_array($estimatedTimeOptions) && empty($estimatedTimeOptions))) {
            unset($this->EstimatedTimeOptions);
        } else {
            $this->EstimatedTimeOptions = $estimatedTimeOptions;
        }
        return $this;
    }
    /**
     * Get TruckStyle value
     * @return string|null
     */
    public function getTruckStyle()
    {
        return $this->TruckStyle;
    }
    /**
     * Set TruckStyle value
     * @uses \Pcm\EnumType\PcmTruckStyle::valueIsValid()
     * @uses \Pcm\EnumType\PcmTruckStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $truckStyle
     * @return \Pcm\StructType\PcmSharedOptions
     */
    public function setTruckStyle($truckStyle = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTruckStyle::valueIsValid($truckStyle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $truckStyle, implode(', ', \Pcm\EnumType\PcmTruckStyle::getValidValues())), __LINE__);
        }
        $this->TruckStyle = $truckStyle;
        return $this;
    }
    /**
     * Get UseTraffic value
     * @return bool|null
     */
    public function getUseTraffic()
    {
        return $this->UseTraffic;
    }
    /**
     * Set UseTraffic value
     * @param bool $useTraffic
     * @return \Pcm\StructType\PcmSharedOptions
     */
    public function setUseTraffic($useTraffic = null)
    {
        $this->UseTraffic = $useTraffic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmSharedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
