<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteMatrixRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteMatrixRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteMatrixRequestBody extends AbstractStructBase
{
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfLocation
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfLocation
     */
    public $Destinations;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteOptions
     */
    public $Options;
    /**
     * Constructor method for RouteMatrixRequestBody
     * @uses PcmRouteMatrixRequestBody::setOrigins()
     * @uses PcmRouteMatrixRequestBody::setDestinations()
     * @uses PcmRouteMatrixRequestBody::setOptions()
     * @param \Pcm\ArrayType\PcmArrayOfLocation $origins
     * @param \Pcm\ArrayType\PcmArrayOfLocation $destinations
     * @param \Pcm\StructType\PcmRouteOptions $options
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfLocation $origins = null, \Pcm\ArrayType\PcmArrayOfLocation $destinations = null, \Pcm\StructType\PcmRouteOptions $options = null)
    {
        $this
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setOptions($options);
    }
    /**
     * Get Origins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfLocation|null
     */
    public function getOrigins()
    {
        return isset($this->Origins) ? $this->Origins : null;
    }
    /**
     * Set Origins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfLocation $origins
     * @return \Pcm\StructType\PcmRouteMatrixRequestBody
     */
    public function setOrigins(\Pcm\ArrayType\PcmArrayOfLocation $origins = null)
    {
        if (is_null($origins) || (is_array($origins) && empty($origins))) {
            unset($this->Origins);
        } else {
            $this->Origins = $origins;
        }
        return $this;
    }
    /**
     * Get Destinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfLocation|null
     */
    public function getDestinations()
    {
        return isset($this->Destinations) ? $this->Destinations : null;
    }
    /**
     * Set Destinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfLocation $destinations
     * @return \Pcm\StructType\PcmRouteMatrixRequestBody
     */
    public function setDestinations(\Pcm\ArrayType\PcmArrayOfLocation $destinations = null)
    {
        if (is_null($destinations) || (is_array($destinations) && empty($destinations))) {
            unset($this->Destinations);
        } else {
            $this->Destinations = $destinations;
        }
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteOptions|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteOptions $options
     * @return \Pcm\StructType\PcmRouteMatrixRequestBody
     */
    public function setOptions(\Pcm\StructType\PcmRouteOptions $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteMatrixRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
