<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteLegOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteLegOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteLegOptions extends AbstractStructBase
{
    /**
     * The LineOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfRouteLineOptions
     */
    public $LineOptions;
    /**
     * The TextOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfRouteLabelOptions
     */
    public $TextOptions;
    /**
     * Constructor method for RouteLegOptions
     * @uses PcmRouteLegOptions::setLineOptions()
     * @uses PcmRouteLegOptions::setTextOptions()
     * @param \Pcm\ArrayType\PcmArrayOfRouteLineOptions $lineOptions
     * @param \Pcm\ArrayType\PcmArrayOfRouteLabelOptions $textOptions
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfRouteLineOptions $lineOptions = null, \Pcm\ArrayType\PcmArrayOfRouteLabelOptions $textOptions = null)
    {
        $this
            ->setLineOptions($lineOptions)
            ->setTextOptions($textOptions);
    }
    /**
     * Get LineOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfRouteLineOptions|null
     */
    public function getLineOptions()
    {
        return isset($this->LineOptions) ? $this->LineOptions : null;
    }
    /**
     * Set LineOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfRouteLineOptions $lineOptions
     * @return \Pcm\StructType\PcmRouteLegOptions
     */
    public function setLineOptions(\Pcm\ArrayType\PcmArrayOfRouteLineOptions $lineOptions = null)
    {
        if (is_null($lineOptions) || (is_array($lineOptions) && empty($lineOptions))) {
            unset($this->LineOptions);
        } else {
            $this->LineOptions = $lineOptions;
        }
        return $this;
    }
    /**
     * Get TextOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfRouteLabelOptions|null
     */
    public function getTextOptions()
    {
        return isset($this->TextOptions) ? $this->TextOptions : null;
    }
    /**
     * Set TextOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfRouteLabelOptions $textOptions
     * @return \Pcm\StructType\PcmRouteLegOptions
     */
    public function setTextOptions(\Pcm\ArrayType\PcmArrayOfRouteLabelOptions $textOptions = null)
    {
        if (is_null($textOptions) || (is_array($textOptions) && empty($textOptions))) {
            unset($this->TextOptions);
        } else {
            $this->TextOptions = $textOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteLegOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
