<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteCosts StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteCosts
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteCosts extends AbstractStructBase
{
    /**
     * The CostTimeEmpty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CostTimeEmpty;
    /**
     * The CostTimeLoaded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CostTimeLoaded;
    /**
     * The FuelEconomyEmpty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FuelEconomyEmpty;
    /**
     * The FuelEconomyLoaded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FuelEconomyLoaded;
    /**
     * The GreenHouseGas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $GreenHouseGas;
    /**
     * The OtherCostPerDistUnitLoaded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OtherCostPerDistUnitLoaded;
    /**
     * The OtherCostPerDistanceUnitEmpty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OtherCostPerDistanceUnitEmpty;
    /**
     * The PricePerFuelUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerFuelUnit;
    /**
     * The TruckStyle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TruckStyle;
    /**
     * Constructor method for RouteCosts
     * @uses PcmRouteCosts::setCostTimeEmpty()
     * @uses PcmRouteCosts::setCostTimeLoaded()
     * @uses PcmRouteCosts::setFuelEconomyEmpty()
     * @uses PcmRouteCosts::setFuelEconomyLoaded()
     * @uses PcmRouteCosts::setGreenHouseGas()
     * @uses PcmRouteCosts::setOtherCostPerDistUnitLoaded()
     * @uses PcmRouteCosts::setOtherCostPerDistanceUnitEmpty()
     * @uses PcmRouteCosts::setPricePerFuelUnit()
     * @uses PcmRouteCosts::setTruckStyle()
     * @param float $costTimeEmpty
     * @param float $costTimeLoaded
     * @param float $fuelEconomyEmpty
     * @param float $fuelEconomyLoaded
     * @param float $greenHouseGas
     * @param float $otherCostPerDistUnitLoaded
     * @param float $otherCostPerDistanceUnitEmpty
     * @param float $pricePerFuelUnit
     * @param string $truckStyle
     */
    public function __construct($costTimeEmpty = null, $costTimeLoaded = null, $fuelEconomyEmpty = null, $fuelEconomyLoaded = null, $greenHouseGas = null, $otherCostPerDistUnitLoaded = null, $otherCostPerDistanceUnitEmpty = null, $pricePerFuelUnit = null, $truckStyle = null)
    {
        $this
            ->setCostTimeEmpty($costTimeEmpty)
            ->setCostTimeLoaded($costTimeLoaded)
            ->setFuelEconomyEmpty($fuelEconomyEmpty)
            ->setFuelEconomyLoaded($fuelEconomyLoaded)
            ->setGreenHouseGas($greenHouseGas)
            ->setOtherCostPerDistUnitLoaded($otherCostPerDistUnitLoaded)
            ->setOtherCostPerDistanceUnitEmpty($otherCostPerDistanceUnitEmpty)
            ->setPricePerFuelUnit($pricePerFuelUnit)
            ->setTruckStyle($truckStyle);
    }
    /**
     * Get CostTimeEmpty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCostTimeEmpty()
    {
        return isset($this->CostTimeEmpty) ? $this->CostTimeEmpty : null;
    }
    /**
     * Set CostTimeEmpty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $costTimeEmpty
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setCostTimeEmpty($costTimeEmpty = null)
    {
        if (is_null($costTimeEmpty) || (is_array($costTimeEmpty) && empty($costTimeEmpty))) {
            unset($this->CostTimeEmpty);
        } else {
            $this->CostTimeEmpty = $costTimeEmpty;
        }
        return $this;
    }
    /**
     * Get CostTimeLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCostTimeLoaded()
    {
        return isset($this->CostTimeLoaded) ? $this->CostTimeLoaded : null;
    }
    /**
     * Set CostTimeLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $costTimeLoaded
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setCostTimeLoaded($costTimeLoaded = null)
    {
        if (is_null($costTimeLoaded) || (is_array($costTimeLoaded) && empty($costTimeLoaded))) {
            unset($this->CostTimeLoaded);
        } else {
            $this->CostTimeLoaded = $costTimeLoaded;
        }
        return $this;
    }
    /**
     * Get FuelEconomyEmpty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFuelEconomyEmpty()
    {
        return isset($this->FuelEconomyEmpty) ? $this->FuelEconomyEmpty : null;
    }
    /**
     * Set FuelEconomyEmpty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fuelEconomyEmpty
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setFuelEconomyEmpty($fuelEconomyEmpty = null)
    {
        if (is_null($fuelEconomyEmpty) || (is_array($fuelEconomyEmpty) && empty($fuelEconomyEmpty))) {
            unset($this->FuelEconomyEmpty);
        } else {
            $this->FuelEconomyEmpty = $fuelEconomyEmpty;
        }
        return $this;
    }
    /**
     * Get FuelEconomyLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFuelEconomyLoaded()
    {
        return isset($this->FuelEconomyLoaded) ? $this->FuelEconomyLoaded : null;
    }
    /**
     * Set FuelEconomyLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fuelEconomyLoaded
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setFuelEconomyLoaded($fuelEconomyLoaded = null)
    {
        if (is_null($fuelEconomyLoaded) || (is_array($fuelEconomyLoaded) && empty($fuelEconomyLoaded))) {
            unset($this->FuelEconomyLoaded);
        } else {
            $this->FuelEconomyLoaded = $fuelEconomyLoaded;
        }
        return $this;
    }
    /**
     * Get GreenHouseGas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGreenHouseGas()
    {
        return isset($this->GreenHouseGas) ? $this->GreenHouseGas : null;
    }
    /**
     * Set GreenHouseGas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $greenHouseGas
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setGreenHouseGas($greenHouseGas = null)
    {
        if (is_null($greenHouseGas) || (is_array($greenHouseGas) && empty($greenHouseGas))) {
            unset($this->GreenHouseGas);
        } else {
            $this->GreenHouseGas = $greenHouseGas;
        }
        return $this;
    }
    /**
     * Get OtherCostPerDistUnitLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOtherCostPerDistUnitLoaded()
    {
        return isset($this->OtherCostPerDistUnitLoaded) ? $this->OtherCostPerDistUnitLoaded : null;
    }
    /**
     * Set OtherCostPerDistUnitLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $otherCostPerDistUnitLoaded
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setOtherCostPerDistUnitLoaded($otherCostPerDistUnitLoaded = null)
    {
        if (is_null($otherCostPerDistUnitLoaded) || (is_array($otherCostPerDistUnitLoaded) && empty($otherCostPerDistUnitLoaded))) {
            unset($this->OtherCostPerDistUnitLoaded);
        } else {
            $this->OtherCostPerDistUnitLoaded = $otherCostPerDistUnitLoaded;
        }
        return $this;
    }
    /**
     * Get OtherCostPerDistanceUnitEmpty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOtherCostPerDistanceUnitEmpty()
    {
        return isset($this->OtherCostPerDistanceUnitEmpty) ? $this->OtherCostPerDistanceUnitEmpty : null;
    }
    /**
     * Set OtherCostPerDistanceUnitEmpty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $otherCostPerDistanceUnitEmpty
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setOtherCostPerDistanceUnitEmpty($otherCostPerDistanceUnitEmpty = null)
    {
        if (is_null($otherCostPerDistanceUnitEmpty) || (is_array($otherCostPerDistanceUnitEmpty) && empty($otherCostPerDistanceUnitEmpty))) {
            unset($this->OtherCostPerDistanceUnitEmpty);
        } else {
            $this->OtherCostPerDistanceUnitEmpty = $otherCostPerDistanceUnitEmpty;
        }
        return $this;
    }
    /**
     * Get PricePerFuelUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerFuelUnit()
    {
        return isset($this->PricePerFuelUnit) ? $this->PricePerFuelUnit : null;
    }
    /**
     * Set PricePerFuelUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerFuelUnit
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setPricePerFuelUnit($pricePerFuelUnit = null)
    {
        if (is_null($pricePerFuelUnit) || (is_array($pricePerFuelUnit) && empty($pricePerFuelUnit))) {
            unset($this->PricePerFuelUnit);
        } else {
            $this->PricePerFuelUnit = $pricePerFuelUnit;
        }
        return $this;
    }
    /**
     * Get TruckStyle value
     * @return string|null
     */
    public function getTruckStyle()
    {
        return $this->TruckStyle;
    }
    /**
     * Set TruckStyle value
     * @uses \Pcm\EnumType\PcmTruckStyle::valueIsValid()
     * @uses \Pcm\EnumType\PcmTruckStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $truckStyle
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public function setTruckStyle($truckStyle = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTruckStyle::valueIsValid($truckStyle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $truckStyle, implode(', ', \Pcm\EnumType\PcmTruckStyle::getValidValues())), __LINE__);
        }
        $this->TruckStyle = $truckStyle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteCosts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
