<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSpeed StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadSpeed
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoadSpeed extends PcmRoadSpeedBase
{
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The AbbreviationFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AbbreviationFormat;
    /**
     * Constructor method for RoadSpeed
     * @uses PcmRoadSpeed::setState()
     * @uses PcmRoadSpeed::setAbbreviationFormat()
     * @param string $state
     * @param string $abbreviationFormat
     */
    public function __construct($state = null, $abbreviationFormat = null)
    {
        $this
            ->setState($state)
            ->setAbbreviationFormat($abbreviationFormat);
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get AbbreviationFormat value
     * @return string|null
     */
    public function getAbbreviationFormat()
    {
        return $this->AbbreviationFormat;
    }
    /**
     * Set AbbreviationFormat value
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abbreviationFormat
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setAbbreviationFormat($abbreviationFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid($abbreviationFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $abbreviationFormat, implode(', ', \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues())), __LINE__);
        }
        $this->AbbreviationFormat = $abbreviationFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
