<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestHeader
 * @package Pcm
 * @subpackage Structs
 */
class PcmRequestHeader extends AbstractStructBase
{
    /**
     * The DataVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataVersion;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestType;
    /**
     * Constructor method for RequestHeader
     * @uses PcmRequestHeader::setDataVersion()
     * @uses PcmRequestHeader::setRequestType()
     * @param string $dataVersion
     * @param string $requestType
     */
    public function __construct($dataVersion = null, $requestType = null)
    {
        $this
            ->setDataVersion($dataVersion)
            ->setRequestType($requestType);
    }
    /**
     * Get DataVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataVersion()
    {
        return isset($this->DataVersion) ? $this->DataVersion : null;
    }
    /**
     * Set DataVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataVersion
     * @return \Pcm\StructType\PcmRequestHeader
     */
    public function setDataVersion($dataVersion = null)
    {
        // validation for constraint: string
        if (!is_null($dataVersion) && !is_string($dataVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVersion)), __LINE__);
        }
        if (is_null($dataVersion) || (is_array($dataVersion) && empty($dataVersion))) {
            unset($this->DataVersion);
        } else {
            $this->DataVersion = $dataVersion;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \Pcm\StructType\PcmRequestHeader
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRequestHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
