<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportRoute StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportRoute
 * @package Pcm
 * @subpackage Structs
 */
class PcmReportRoute extends PcmRoute
{
    /**
     * The ReportingOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmReportOptions
     */
    public $ReportingOptions;
    /**
     * The ReportTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfReportType
     */
    public $ReportTypes;
    /**
     * Constructor method for ReportRoute
     * @uses PcmReportRoute::setReportingOptions()
     * @uses PcmReportRoute::setReportTypes()
     * @param \Pcm\StructType\PcmReportOptions $reportingOptions
     * @param \Pcm\ArrayType\PcmArrayOfReportType $reportTypes
     */
    public function __construct(\Pcm\StructType\PcmReportOptions $reportingOptions = null, \Pcm\ArrayType\PcmArrayOfReportType $reportTypes = null)
    {
        $this
            ->setReportingOptions($reportingOptions)
            ->setReportTypes($reportTypes);
    }
    /**
     * Get ReportingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmReportOptions|null
     */
    public function getReportingOptions()
    {
        return isset($this->ReportingOptions) ? $this->ReportingOptions : null;
    }
    /**
     * Set ReportingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmReportOptions $reportingOptions
     * @return \Pcm\StructType\PcmReportRoute
     */
    public function setReportingOptions(\Pcm\StructType\PcmReportOptions $reportingOptions = null)
    {
        if (is_null($reportingOptions) || (is_array($reportingOptions) && empty($reportingOptions))) {
            unset($this->ReportingOptions);
        } else {
            $this->ReportingOptions = $reportingOptions;
        }
        return $this;
    }
    /**
     * Get ReportTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfReportType|null
     */
    public function getReportTypes()
    {
        return isset($this->ReportTypes) ? $this->ReportTypes : null;
    }
    /**
     * Set ReportTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfReportType $reportTypes
     * @return \Pcm\StructType\PcmReportRoute
     */
    public function setReportTypes(\Pcm\ArrayType\PcmArrayOfReportType $reportTypes = null)
    {
        if (is_null($reportTypes) || (is_array($reportTypes) && empty($reportTypes))) {
            unset($this->ReportTypes);
        } else {
            $this->ReportTypes = $reportTypes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReportRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
