<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmReportOptions extends PcmSharedOptions
{
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The FuelUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FuelUnits;
    /**
     * The IncludeFerryDistance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeFerryDistance;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The RouteCosts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteCosts
     */
    public $RouteCosts;
    /**
     * The TimeCosts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmTimeCosts
     */
    public $TimeCosts;
    /**
     * The TollCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TollCurrency;
    /**
     * The TollDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TollDiscount;
    /**
     * The UseCustomRoadSpeeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseCustomRoadSpeeds;
    /**
     * The UseTollData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseTollData;
    /**
     * Constructor method for ReportOptions
     * @uses PcmReportOptions::setExchangeRate()
     * @uses PcmReportOptions::setFuelUnits()
     * @uses PcmReportOptions::setIncludeFerryDistance()
     * @uses PcmReportOptions::setLanguage()
     * @uses PcmReportOptions::setRouteCosts()
     * @uses PcmReportOptions::setTimeCosts()
     * @uses PcmReportOptions::setTollCurrency()
     * @uses PcmReportOptions::setTollDiscount()
     * @uses PcmReportOptions::setUseCustomRoadSpeeds()
     * @uses PcmReportOptions::setUseTollData()
     * @param float $exchangeRate
     * @param string $fuelUnits
     * @param bool $includeFerryDistance
     * @param string $language
     * @param \Pcm\StructType\PcmRouteCosts $routeCosts
     * @param \Pcm\StructType\PcmTimeCosts $timeCosts
     * @param string $tollCurrency
     * @param string $tollDiscount
     * @param bool $useCustomRoadSpeeds
     * @param bool $useTollData
     */
    public function __construct($exchangeRate = null, $fuelUnits = null, $includeFerryDistance = null, $language = null, \Pcm\StructType\PcmRouteCosts $routeCosts = null, \Pcm\StructType\PcmTimeCosts $timeCosts = null, $tollCurrency = null, $tollDiscount = null, $useCustomRoadSpeeds = null, $useTollData = null)
    {
        $this
            ->setExchangeRate($exchangeRate)
            ->setFuelUnits($fuelUnits)
            ->setIncludeFerryDistance($includeFerryDistance)
            ->setLanguage($language)
            ->setRouteCosts($routeCosts)
            ->setTimeCosts($timeCosts)
            ->setTollCurrency($tollCurrency)
            ->setTollDiscount($tollDiscount)
            ->setUseCustomRoadSpeeds($useCustomRoadSpeeds)
            ->setUseTollData($useTollData);
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get FuelUnits value
     * @return string|null
     */
    public function getFuelUnits()
    {
        return $this->FuelUnits;
    }
    /**
     * Set FuelUnits value
     * @uses \Pcm\EnumType\PcmVolumeUnits::valueIsValid()
     * @uses \Pcm\EnumType\PcmVolumeUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fuelUnits
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setFuelUnits($fuelUnits = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVolumeUnits::valueIsValid($fuelUnits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fuelUnits, implode(', ', \Pcm\EnumType\PcmVolumeUnits::getValidValues())), __LINE__);
        }
        $this->FuelUnits = $fuelUnits;
        return $this;
    }
    /**
     * Get IncludeFerryDistance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeFerryDistance()
    {
        return isset($this->IncludeFerryDistance) ? $this->IncludeFerryDistance : null;
    }
    /**
     * Set IncludeFerryDistance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeFerryDistance
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setIncludeFerryDistance($includeFerryDistance = null)
    {
        if (is_null($includeFerryDistance) || (is_array($includeFerryDistance) && empty($includeFerryDistance))) {
            unset($this->IncludeFerryDistance);
        } else {
            $this->IncludeFerryDistance = $includeFerryDistance;
        }
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \Pcm\EnumType\PcmLanguageType::valueIsValid()
     * @uses \Pcm\EnumType\PcmLanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmLanguageType::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \Pcm\EnumType\PcmLanguageType::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get RouteCosts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteCosts|null
     */
    public function getRouteCosts()
    {
        return isset($this->RouteCosts) ? $this->RouteCosts : null;
    }
    /**
     * Set RouteCosts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteCosts $routeCosts
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setRouteCosts(\Pcm\StructType\PcmRouteCosts $routeCosts = null)
    {
        if (is_null($routeCosts) || (is_array($routeCosts) && empty($routeCosts))) {
            unset($this->RouteCosts);
        } else {
            $this->RouteCosts = $routeCosts;
        }
        return $this;
    }
    /**
     * Get TimeCosts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmTimeCosts|null
     */
    public function getTimeCosts()
    {
        return isset($this->TimeCosts) ? $this->TimeCosts : null;
    }
    /**
     * Set TimeCosts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmTimeCosts $timeCosts
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setTimeCosts(\Pcm\StructType\PcmTimeCosts $timeCosts = null)
    {
        if (is_null($timeCosts) || (is_array($timeCosts) && empty($timeCosts))) {
            unset($this->TimeCosts);
        } else {
            $this->TimeCosts = $timeCosts;
        }
        return $this;
    }
    /**
     * Get TollCurrency value
     * @return string|null
     */
    public function getTollCurrency()
    {
        return $this->TollCurrency;
    }
    /**
     * Set TollCurrency value
     * @uses \Pcm\EnumType\PcmCurrency::valueIsValid()
     * @uses \Pcm\EnumType\PcmCurrency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tollCurrency
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setTollCurrency($tollCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCurrency::valueIsValid($tollCurrency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tollCurrency, implode(', ', \Pcm\EnumType\PcmCurrency::getValidValues())), __LINE__);
        }
        $this->TollCurrency = $tollCurrency;
        return $this;
    }
    /**
     * Get TollDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTollDiscount()
    {
        return isset($this->TollDiscount) ? $this->TollDiscount : null;
    }
    /**
     * Set TollDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tollDiscount
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setTollDiscount($tollDiscount = null)
    {
        // validation for constraint: string
        if (!is_null($tollDiscount) && !is_string($tollDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tollDiscount)), __LINE__);
        }
        if (is_null($tollDiscount) || (is_array($tollDiscount) && empty($tollDiscount))) {
            unset($this->TollDiscount);
        } else {
            $this->TollDiscount = $tollDiscount;
        }
        return $this;
    }
    /**
     * Get UseCustomRoadSpeeds value
     * @return bool|null
     */
    public function getUseCustomRoadSpeeds()
    {
        return $this->UseCustomRoadSpeeds;
    }
    /**
     * Set UseCustomRoadSpeeds value
     * @param bool $useCustomRoadSpeeds
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setUseCustomRoadSpeeds($useCustomRoadSpeeds = null)
    {
        $this->UseCustomRoadSpeeds = $useCustomRoadSpeeds;
        return $this;
    }
    /**
     * Get UseTollData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseTollData()
    {
        return isset($this->UseTollData) ? $this->UseTollData : null;
    }
    /**
     * Set UseTollData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useTollData
     * @return \Pcm\StructType\PcmReportOptions
     */
    public function setUseTollData($useTollData = null)
    {
        if (is_null($useTollData) || (is_array($useTollData) && empty($useTollData))) {
            unset($this->UseTollData);
        } else {
            $this->UseTollData = $useTollData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReportOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
