<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderedMap StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderedMap
 * @package Pcm
 * @subpackage Structs
 */
class PcmRenderedMap extends AbstractStructBase
{
    /**
     * The Center
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Center;
    /**
     * The CornerA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $CornerA;
    /**
     * The CornerB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $CornerB;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfMapGroupInfo
     */
    public $Groups;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Layers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfLayer
     */
    public $Layers;
    /**
     * The Points
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfMapPointInfo
     */
    public $Points;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * Constructor method for RenderedMap
     * @uses PcmRenderedMap::setCenter()
     * @uses PcmRenderedMap::setCornerA()
     * @uses PcmRenderedMap::setCornerB()
     * @uses PcmRenderedMap::setGroups()
     * @uses PcmRenderedMap::setHeight()
     * @uses PcmRenderedMap::setLayers()
     * @uses PcmRenderedMap::setPoints()
     * @uses PcmRenderedMap::setRegion()
     * @uses PcmRenderedMap::setWidth()
     * @param \Pcm\StructType\PcmCoordinates $center
     * @param \Pcm\StructType\PcmCoordinates $cornerA
     * @param \Pcm\StructType\PcmCoordinates $cornerB
     * @param \Pcm\ArrayType\PcmArrayOfMapGroupInfo $groups
     * @param int $height
     * @param \Pcm\ArrayType\PcmArrayOfLayer $layers
     * @param \Pcm\ArrayType\PcmArrayOfMapPointInfo $points
     * @param string $region
     * @param int $width
     */
    public function __construct(\Pcm\StructType\PcmCoordinates $center = null, \Pcm\StructType\PcmCoordinates $cornerA = null, \Pcm\StructType\PcmCoordinates $cornerB = null, \Pcm\ArrayType\PcmArrayOfMapGroupInfo $groups = null, $height = null, \Pcm\ArrayType\PcmArrayOfLayer $layers = null, \Pcm\ArrayType\PcmArrayOfMapPointInfo $points = null, $region = null, $width = null)
    {
        $this
            ->setCenter($center)
            ->setCornerA($cornerA)
            ->setCornerB($cornerB)
            ->setGroups($groups)
            ->setHeight($height)
            ->setLayers($layers)
            ->setPoints($points)
            ->setRegion($region)
            ->setWidth($width);
    }
    /**
     * Get Center value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCenter()
    {
        return isset($this->Center) ? $this->Center : null;
    }
    /**
     * Set Center value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $center
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setCenter(\Pcm\StructType\PcmCoordinates $center = null)
    {
        if (is_null($center) || (is_array($center) && empty($center))) {
            unset($this->Center);
        } else {
            $this->Center = $center;
        }
        return $this;
    }
    /**
     * Get CornerA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCornerA()
    {
        return isset($this->CornerA) ? $this->CornerA : null;
    }
    /**
     * Set CornerA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $cornerA
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setCornerA(\Pcm\StructType\PcmCoordinates $cornerA = null)
    {
        if (is_null($cornerA) || (is_array($cornerA) && empty($cornerA))) {
            unset($this->CornerA);
        } else {
            $this->CornerA = $cornerA;
        }
        return $this;
    }
    /**
     * Get CornerB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCornerB()
    {
        return isset($this->CornerB) ? $this->CornerB : null;
    }
    /**
     * Set CornerB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $cornerB
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setCornerB(\Pcm\StructType\PcmCoordinates $cornerB = null)
    {
        if (is_null($cornerB) || (is_array($cornerB) && empty($cornerB))) {
            unset($this->CornerB);
        } else {
            $this->CornerB = $cornerB;
        }
        return $this;
    }
    /**
     * Get Groups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfMapGroupInfo|null
     */
    public function getGroups()
    {
        return isset($this->Groups) ? $this->Groups : null;
    }
    /**
     * Set Groups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfMapGroupInfo $groups
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setGroups(\Pcm\ArrayType\PcmArrayOfMapGroupInfo $groups = null)
    {
        if (is_null($groups) || (is_array($groups) && empty($groups))) {
            unset($this->Groups);
        } else {
            $this->Groups = $groups;
        }
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !is_numeric($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Layers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfLayer|null
     */
    public function getLayers()
    {
        return isset($this->Layers) ? $this->Layers : null;
    }
    /**
     * Set Layers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfLayer $layers
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setLayers(\Pcm\ArrayType\PcmArrayOfLayer $layers = null)
    {
        if (is_null($layers) || (is_array($layers) && empty($layers))) {
            unset($this->Layers);
        } else {
            $this->Layers = $layers;
        }
        return $this;
    }
    /**
     * Get Points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfMapPointInfo|null
     */
    public function getPoints()
    {
        return isset($this->Points) ? $this->Points : null;
    }
    /**
     * Set Points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfMapPointInfo $points
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setPoints(\Pcm\ArrayType\PcmArrayOfMapPointInfo $points = null)
    {
        if (is_null($points) || (is_array($points) && empty($points))) {
            unset($this->Points);
        } else {
            $this->Points = $points;
        }
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmMapRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmMapRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmMapRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmMapRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRenderedMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
