<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RadiusSearchMatch StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RadiusSearchMatch
 * @package Pcm
 * @subpackage Structs
 */
class PcmRadiusSearchMatch extends AbstractStructBase
{
    /**
     * The DistanceFromCenter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDistance
     */
    public $DistanceFromCenter;
    /**
     * The POICategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $POICategory;
    /**
     * The POILocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmLocation
     */
    public $POILocation;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring
     */
    public $Info;
    /**
     * Constructor method for RadiusSearchMatch
     * @uses PcmRadiusSearchMatch::setDistanceFromCenter()
     * @uses PcmRadiusSearchMatch::setPOICategory()
     * @uses PcmRadiusSearchMatch::setPOILocation()
     * @uses PcmRadiusSearchMatch::setInfo()
     * @param \Pcm\StructType\PcmDistance $distanceFromCenter
     * @param string $pOICategory
     * @param \Pcm\StructType\PcmLocation $pOILocation
     * @param \Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring $info
     */
    public function __construct(\Pcm\StructType\PcmDistance $distanceFromCenter = null, $pOICategory = null, \Pcm\StructType\PcmLocation $pOILocation = null, \Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring $info = null)
    {
        $this
            ->setDistanceFromCenter($distanceFromCenter)
            ->setPOICategory($pOICategory)
            ->setPOILocation($pOILocation)
            ->setInfo($info);
    }
    /**
     * Get DistanceFromCenter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDistance|null
     */
    public function getDistanceFromCenter()
    {
        return isset($this->DistanceFromCenter) ? $this->DistanceFromCenter : null;
    }
    /**
     * Set DistanceFromCenter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmDistance $distanceFromCenter
     * @return \Pcm\StructType\PcmRadiusSearchMatch
     */
    public function setDistanceFromCenter(\Pcm\StructType\PcmDistance $distanceFromCenter = null)
    {
        if (is_null($distanceFromCenter) || (is_array($distanceFromCenter) && empty($distanceFromCenter))) {
            unset($this->DistanceFromCenter);
        } else {
            $this->DistanceFromCenter = $distanceFromCenter;
        }
        return $this;
    }
    /**
     * Get POICategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPOICategory()
    {
        return isset($this->POICategory) ? $this->POICategory : null;
    }
    /**
     * Set POICategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pOICategory
     * @return \Pcm\StructType\PcmRadiusSearchMatch
     */
    public function setPOICategory($pOICategory = null)
    {
        // validation for constraint: string
        if (!is_null($pOICategory) && !is_string($pOICategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pOICategory)), __LINE__);
        }
        if (is_null($pOICategory) || (is_array($pOICategory) && empty($pOICategory))) {
            unset($this->POICategory);
        } else {
            $this->POICategory = $pOICategory;
        }
        return $this;
    }
    /**
     * Get POILocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmLocation|null
     */
    public function getPOILocation()
    {
        return isset($this->POILocation) ? $this->POILocation : null;
    }
    /**
     * Set POILocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmLocation $pOILocation
     * @return \Pcm\StructType\PcmRadiusSearchMatch
     */
    public function setPOILocation(\Pcm\StructType\PcmLocation $pOILocation = null)
    {
        if (is_null($pOILocation) || (is_array($pOILocation) && empty($pOILocation))) {
            unset($this->POILocation);
        } else {
            $this->POILocation = $pOILocation;
        }
        return $this;
    }
    /**
     * Get Info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring|null
     */
    public function getInfo()
    {
        return isset($this->Info) ? $this->Info : null;
    }
    /**
     * Set Info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring $info
     * @return \Pcm\StructType\PcmRadiusSearchMatch
     */
    public function setInfo(\Pcm\ArrayType\PcmArrayOfKeyValuePairOfstringstring $info = null)
    {
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->Info);
        } else {
            $this->Info = $info;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRadiusSearchMatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
