<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGB StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RGB
 * @package Pcm
 * @subpackage Structs
 */
class PcmRGB extends AbstractStructBase
{
    /**
     * The Red
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Red;
    /**
     * The Green
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Green;
    /**
     * The Blue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Blue;
    /**
     * Constructor method for RGB
     * @uses PcmRGB::setRed()
     * @uses PcmRGB::setGreen()
     * @uses PcmRGB::setBlue()
     * @param string $red
     * @param string $green
     * @param string $blue
     */
    public function __construct($red = null, $green = null, $blue = null)
    {
        $this
            ->setRed($red)
            ->setGreen($green)
            ->setBlue($blue);
    }
    /**
     * Get Red value
     * @return string|null
     */
    public function getRed()
    {
        return $this->Red;
    }
    /**
     * Set Red value
     * @param string $red
     * @return \Pcm\StructType\PcmRGB
     */
    public function setRed($red = null)
    {
        // validation for constraint: string
        if (!is_null($red) && !is_string($red)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($red)), __LINE__);
        }
        $this->Red = $red;
        return $this;
    }
    /**
     * Get Green value
     * @return string|null
     */
    public function getGreen()
    {
        return $this->Green;
    }
    /**
     * Set Green value
     * @param string $green
     * @return \Pcm\StructType\PcmRGB
     */
    public function setGreen($green = null)
    {
        // validation for constraint: string
        if (!is_null($green) && !is_string($green)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($green)), __LINE__);
        }
        $this->Green = $green;
        return $this;
    }
    /**
     * Get Blue value
     * @return string|null
     */
    public function getBlue()
    {
        return $this->Blue;
    }
    /**
     * Set Blue value
     * @param string $blue
     * @return \Pcm\StructType\PcmRGB
     */
    public function setBlue($blue = null)
    {
        // validation for constraint: string
        if (!is_null($blue) && !is_string($blue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blue)), __LINE__);
        }
        $this->Blue = $blue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRGB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
