<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MileageReport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MileageReport
 * @package Pcm
 * @subpackage Structs
 */
class PcmMileageReport extends PcmReport
{
    /**
     * The ReportLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfStopReportLine
     */
    public $ReportLines;
    /**
     * The TrafficDataUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrafficDataUsed;
    /**
     * Constructor method for MileageReport
     * @uses PcmMileageReport::setReportLines()
     * @uses PcmMileageReport::setTrafficDataUsed()
     * @param \Pcm\ArrayType\PcmArrayOfStopReportLine $reportLines
     * @param bool $trafficDataUsed
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfStopReportLine $reportLines = null, $trafficDataUsed = null)
    {
        $this
            ->setReportLines($reportLines)
            ->setTrafficDataUsed($trafficDataUsed);
    }
    /**
     * Get ReportLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfStopReportLine|null
     */
    public function getReportLines()
    {
        return isset($this->ReportLines) ? $this->ReportLines : null;
    }
    /**
     * Set ReportLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfStopReportLine $reportLines
     * @return \Pcm\StructType\PcmMileageReport
     */
    public function setReportLines(\Pcm\ArrayType\PcmArrayOfStopReportLine $reportLines = null)
    {
        if (is_null($reportLines) || (is_array($reportLines) && empty($reportLines))) {
            unset($this->ReportLines);
        } else {
            $this->ReportLines = $reportLines;
        }
        return $this;
    }
    /**
     * Get TrafficDataUsed value
     * @return bool|null
     */
    public function getTrafficDataUsed()
    {
        return $this->TrafficDataUsed;
    }
    /**
     * Set TrafficDataUsed value
     * @param bool $trafficDataUsed
     * @return \Pcm\StructType\PcmMileageReport
     */
    public function setTrafficDataUsed($trafficDataUsed = null)
    {
        $this->TrafficDataUsed = $trafficDataUsed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMileageReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
