<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapRoutesRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapRoutesRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapRoutesRequestBody extends AbstractStructBase
{
    /**
     * The Map
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmMapRequestBody
     */
    public $Map;
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfMapRoute
     */
    public $Routes;
    /**
     * Constructor method for MapRoutesRequestBody
     * @uses PcmMapRoutesRequestBody::setMap()
     * @uses PcmMapRoutesRequestBody::setRoutes()
     * @param \Pcm\StructType\PcmMapRequestBody $map
     * @param \Pcm\ArrayType\PcmArrayOfMapRoute $routes
     */
    public function __construct(\Pcm\StructType\PcmMapRequestBody $map = null, \Pcm\ArrayType\PcmArrayOfMapRoute $routes = null)
    {
        $this
            ->setMap($map)
            ->setRoutes($routes);
    }
    /**
     * Get Map value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmMapRequestBody|null
     */
    public function getMap()
    {
        return isset($this->Map) ? $this->Map : null;
    }
    /**
     * Set Map value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmMapRequestBody $map
     * @return \Pcm\StructType\PcmMapRoutesRequestBody
     */
    public function setMap(\Pcm\StructType\PcmMapRequestBody $map = null)
    {
        if (is_null($map) || (is_array($map) && empty($map))) {
            unset($this->Map);
        } else {
            $this->Map = $map;
        }
        return $this;
    }
    /**
     * Get Routes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfMapRoute|null
     */
    public function getRoutes()
    {
        return isset($this->Routes) ? $this->Routes : null;
    }
    /**
     * Set Routes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfMapRoute $routes
     * @return \Pcm\StructType\PcmMapRoutesRequestBody
     */
    public function setRoutes(\Pcm\ArrayType\PcmArrayOfMapRoute $routes = null)
    {
        if (is_null($routes) || (is_array($routes) && empty($routes))) {
            unset($this->Routes);
        } else {
            $this->Routes = $routes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapRoutesRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
