<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoursOfServiceOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HoursOfServiceOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmHoursOfServiceOptions extends AbstractStructBase
{
    /**
     * The Enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The RemainingDriveTimeUntilBreak
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingDriveTimeUntilBreak;
    /**
     * The RemainingDriveTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingDriveTime;
    /**
     * The RemainingOnDutyTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingOnDutyTime;
    /**
     * The HoSRuleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HoSRuleType;
    /**
     * The RemainingCycleDutyTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingCycleDutyTime;
    /**
     * Constructor method for HoursOfServiceOptions
     * @uses PcmHoursOfServiceOptions::setEnabled()
     * @uses PcmHoursOfServiceOptions::setRemainingDriveTimeUntilBreak()
     * @uses PcmHoursOfServiceOptions::setRemainingDriveTime()
     * @uses PcmHoursOfServiceOptions::setRemainingOnDutyTime()
     * @uses PcmHoursOfServiceOptions::setHoSRuleType()
     * @uses PcmHoursOfServiceOptions::setRemainingCycleDutyTime()
     * @param bool $enabled
     * @param float $remainingDriveTimeUntilBreak
     * @param float $remainingDriveTime
     * @param float $remainingOnDutyTime
     * @param string $hoSRuleType
     * @param float $remainingCycleDutyTime
     */
    public function __construct($enabled = null, $remainingDriveTimeUntilBreak = null, $remainingDriveTime = null, $remainingOnDutyTime = null, $hoSRuleType = null, $remainingCycleDutyTime = null)
    {
        $this
            ->setEnabled($enabled)
            ->setRemainingDriveTimeUntilBreak($remainingDriveTimeUntilBreak)
            ->setRemainingDriveTime($remainingDriveTime)
            ->setRemainingOnDutyTime($remainingOnDutyTime)
            ->setHoSRuleType($hoSRuleType)
            ->setRemainingCycleDutyTime($remainingCycleDutyTime);
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setEnabled($enabled = null)
    {
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get RemainingDriveTimeUntilBreak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingDriveTimeUntilBreak()
    {
        return isset($this->RemainingDriveTimeUntilBreak) ? $this->RemainingDriveTimeUntilBreak : null;
    }
    /**
     * Set RemainingDriveTimeUntilBreak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingDriveTimeUntilBreak
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setRemainingDriveTimeUntilBreak($remainingDriveTimeUntilBreak = null)
    {
        if (is_null($remainingDriveTimeUntilBreak) || (is_array($remainingDriveTimeUntilBreak) && empty($remainingDriveTimeUntilBreak))) {
            unset($this->RemainingDriveTimeUntilBreak);
        } else {
            $this->RemainingDriveTimeUntilBreak = $remainingDriveTimeUntilBreak;
        }
        return $this;
    }
    /**
     * Get RemainingDriveTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingDriveTime()
    {
        return isset($this->RemainingDriveTime) ? $this->RemainingDriveTime : null;
    }
    /**
     * Set RemainingDriveTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingDriveTime
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setRemainingDriveTime($remainingDriveTime = null)
    {
        if (is_null($remainingDriveTime) || (is_array($remainingDriveTime) && empty($remainingDriveTime))) {
            unset($this->RemainingDriveTime);
        } else {
            $this->RemainingDriveTime = $remainingDriveTime;
        }
        return $this;
    }
    /**
     * Get RemainingOnDutyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingOnDutyTime()
    {
        return isset($this->RemainingOnDutyTime) ? $this->RemainingOnDutyTime : null;
    }
    /**
     * Set RemainingOnDutyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingOnDutyTime
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setRemainingOnDutyTime($remainingOnDutyTime = null)
    {
        if (is_null($remainingOnDutyTime) || (is_array($remainingOnDutyTime) && empty($remainingOnDutyTime))) {
            unset($this->RemainingOnDutyTime);
        } else {
            $this->RemainingOnDutyTime = $remainingOnDutyTime;
        }
        return $this;
    }
    /**
     * Get HoSRuleType value
     * @return string|null
     */
    public function getHoSRuleType()
    {
        return $this->HoSRuleType;
    }
    /**
     * Set HoSRuleType value
     * @uses \Pcm\EnumType\PcmHoSScheduleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmHoSScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hoSRuleType
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setHoSRuleType($hoSRuleType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmHoSScheduleType::valueIsValid($hoSRuleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hoSRuleType, implode(', ', \Pcm\EnumType\PcmHoSScheduleType::getValidValues())), __LINE__);
        }
        $this->HoSRuleType = $hoSRuleType;
        return $this;
    }
    /**
     * Get RemainingCycleDutyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingCycleDutyTime()
    {
        return isset($this->RemainingCycleDutyTime) ? $this->RemainingCycleDutyTime : null;
    }
    /**
     * Set RemainingCycleDutyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingCycleDutyTime
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setRemainingCycleDutyTime($remainingCycleDutyTime = null)
    {
        if (is_null($remainingCycleDutyTime) || (is_array($remainingCycleDutyTime) && empty($remainingCycleDutyTime))) {
            unset($this->RemainingCycleDutyTime);
        } else {
            $this->RemainingCycleDutyTime = $remainingCycleDutyTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
