<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStatesRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetStatesRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmGetStatesRequestBody extends AbstractStructBase
{
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The CountryOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CountryOnly;
    /**
     * Constructor method for GetStatesRequestBody
     * @uses PcmGetStatesRequestBody::setFormat()
     * @uses PcmGetStatesRequestBody::setRegion()
     * @uses PcmGetStatesRequestBody::setCountryOnly()
     * @param string $format
     * @param string $region
     * @param bool $countryOnly
     */
    public function __construct($format = null, $region = null, $countryOnly = null)
    {
        $this
            ->setFormat($format)
            ->setRegion($region)
            ->setCountryOnly($countryOnly);
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \Pcm\EnumType\PcmCountryCodeFormat::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryCodeFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Pcm\StructType\PcmGetStatesRequestBody
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryCodeFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', \Pcm\EnumType\PcmCountryCodeFormat::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmGetStatesRequestBody
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get CountryOnly value
     * @return bool|null
     */
    public function getCountryOnly()
    {
        return $this->CountryOnly;
    }
    /**
     * Set CountryOnly value
     * @param bool $countryOnly
     * @return \Pcm\StructType\PcmGetStatesRequestBody
     */
    public function setCountryOnly($countryOnly = null)
    {
        $this->CountryOnly = $countryOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGetStatesRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
