<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeofenceSet StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeofenceSet
 * @package Pcm
 * @subpackage Structs
 */
class PcmGeofenceSet extends PcmAddGeofenceSet
{
    /**
     * The Deleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Deleted;
    /**
     * The Fences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfGeofence
     */
    public $Fences;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * Constructor method for GeofenceSet
     * @uses PcmGeofenceSet::setDeleted()
     * @uses PcmGeofenceSet::setFences()
     * @uses PcmGeofenceSet::setId()
     * @param bool $deleted
     * @param \Pcm\ArrayType\PcmArrayOfGeofence $fences
     * @param int $id
     */
    public function __construct($deleted = null, \Pcm\ArrayType\PcmArrayOfGeofence $fences = null, $id = null)
    {
        $this
            ->setDeleted($deleted)
            ->setFences($fences)
            ->setId($id);
    }
    /**
     * Get Deleted value
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->Deleted;
    }
    /**
     * Set Deleted value
     * @param bool $deleted
     * @return \Pcm\StructType\PcmGeofenceSet
     */
    public function setDeleted($deleted = null)
    {
        $this->Deleted = $deleted;
        return $this;
    }
    /**
     * Get Fences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfGeofence|null
     */
    public function getFences()
    {
        return isset($this->Fences) ? $this->Fences : null;
    }
    /**
     * Set Fences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfGeofence $fences
     * @return \Pcm\StructType\PcmGeofenceSet
     */
    public function setFences(\Pcm\ArrayType\PcmArrayOfGeofence $fences = null)
    {
        if (is_null($fences) || (is_array($fences) && empty($fences))) {
            unset($this->Fences);
        } else {
            $this->Fences = $fences;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Pcm\StructType\PcmGeofenceSet
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGeofenceSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
