<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriveTimePolygonRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DriveTimePolygonRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmDriveTimePolygonRequestBody extends AbstractStructBase
{
    /**
     * The Center
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Center;
    /**
     * The Minutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Minutes;
    /**
     * The RouteOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteOptions
     */
    public $RouteOptions;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * Constructor method for DriveTimePolygonRequestBody
     * @uses PcmDriveTimePolygonRequestBody::setCenter()
     * @uses PcmDriveTimePolygonRequestBody::setMinutes()
     * @uses PcmDriveTimePolygonRequestBody::setRouteOptions()
     * @uses PcmDriveTimePolygonRequestBody::setRegion()
     * @param \Pcm\StructType\PcmCoordinates $center
     * @param int $minutes
     * @param \Pcm\StructType\PcmRouteOptions $routeOptions
     * @param string $region
     */
    public function __construct(\Pcm\StructType\PcmCoordinates $center = null, $minutes = null, \Pcm\StructType\PcmRouteOptions $routeOptions = null, $region = null)
    {
        $this
            ->setCenter($center)
            ->setMinutes($minutes)
            ->setRouteOptions($routeOptions)
            ->setRegion($region);
    }
    /**
     * Get Center value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCenter()
    {
        return isset($this->Center) ? $this->Center : null;
    }
    /**
     * Set Center value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $center
     * @return \Pcm\StructType\PcmDriveTimePolygonRequestBody
     */
    public function setCenter(\Pcm\StructType\PcmCoordinates $center = null)
    {
        if (is_null($center) || (is_array($center) && empty($center))) {
            unset($this->Center);
        } else {
            $this->Center = $center;
        }
        return $this;
    }
    /**
     * Get Minutes value
     * @return int|null
     */
    public function getMinutes()
    {
        return $this->Minutes;
    }
    /**
     * Set Minutes value
     * @param int $minutes
     * @return \Pcm\StructType\PcmDriveTimePolygonRequestBody
     */
    public function setMinutes($minutes = null)
    {
        // validation for constraint: int
        if (!is_null($minutes) && !is_numeric($minutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minutes)), __LINE__);
        }
        $this->Minutes = $minutes;
        return $this;
    }
    /**
     * Get RouteOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteOptions|null
     */
    public function getRouteOptions()
    {
        return isset($this->RouteOptions) ? $this->RouteOptions : null;
    }
    /**
     * Set RouteOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteOptions $routeOptions
     * @return \Pcm\StructType\PcmDriveTimePolygonRequestBody
     */
    public function setRouteOptions(\Pcm\StructType\PcmRouteOptions $routeOptions = null)
    {
        if (is_null($routeOptions) || (is_array($routeOptions) && empty($routeOptions))) {
            unset($this->RouteOptions);
        } else {
            $this->RouteOptions = $routeOptions;
        }
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmDriveTimePolygonRequestBody
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmDriveTimePolygonRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
